/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.FixedFourWriter;
import org.apache.qpid.server.protocol.v1_0.codec.FixedOneWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;

public class UnsignedIntegerWriter {
    private static final byte EIGHT_BYTE_FORMAT_CODE = 112;
    private static final byte ONE_BYTE_FORMAT_CODE = 82;
    private static final byte ZERO_BYTE_FORMAT_CODE = 67;
    private static final ValueWriter<UnsignedInteger> ZERO_BYTE_WRITER = new ValueWriter<UnsignedInteger>(){

        @Override
        public int getEncodedSize() {
            return 1;
        }

        @Override
        public void writeToBuffer(QpidByteBuffer buffer) {
            buffer.put((byte)67);
        }
    };
    private static final ValueWriter.Factory<UnsignedInteger> FACTORY = (registry, uint) -> {
        if (uint.equals(UnsignedInteger.ZERO)) {
            return ZERO_BYTE_WRITER;
        }
        if (uint.compareTo(UnsignedInteger.valueOf(256)) < 0) {
            return new UnsignedIntegerFixedOneWriter((UnsignedInteger)uint);
        }
        return new UnsignedIntegerFixedFourWriter((UnsignedInteger)uint);
    };

    public static void register(ValueWriter.Registry registry) {
        registry.register(UnsignedInteger.class, FACTORY);
    }

    private static class UnsignedIntegerFixedOneWriter
    extends FixedOneWriter<UnsignedInteger> {
        UnsignedIntegerFixedOneWriter(UnsignedInteger value) {
            super(value.byteValue());
        }

        @Override
        protected byte getFormatCode() {
            return 82;
        }
    }

    private static class UnsignedIntegerFixedFourWriter
    extends FixedFourWriter<UnsignedInteger> {
        UnsignedIntegerFixedFourWriter(UnsignedInteger object) {
            super(object.intValue());
        }

        @Override
        byte getFormatCode() {
            return 112;
        }
    }
}

