/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.QueueConsumerNode;
import org.apache.qpid.server.queue.QueueConsumerNodeIterator;
import org.apache.qpid.server.queue.QueueConsumerNodeListEntry;

class QueueConsumerNodeList {
    private final QueueConsumerNodeListEntry _head;
    private final AtomicReference<QueueConsumerNodeListEntry> _tail;
    private final AtomicInteger _size = new AtomicInteger();
    private final AtomicInteger _scavengeCount = new AtomicInteger();
    private final int _scavengeCountThreshold;

    QueueConsumerNodeList(Queue<?> queue) {
        this._head = new QueueConsumerNodeListEntry(this);
        this._tail = new AtomicReference<QueueConsumerNodeListEntry>(this._head);
        this._scavengeCountThreshold = queue.getContextValue(Integer.class, "qpid.queue.scavenge_count");
    }

    private void insert(QueueConsumerNodeListEntry node, boolean count) {
        while (true) {
            QueueConsumerNodeListEntry tail = this._tail.get();
            QueueConsumerNodeListEntry next = tail.nextNode();
            if (tail != this._tail.get()) continue;
            if (next == null) {
                if (!tail.setNext(node)) continue;
                this._tail.compareAndSet(tail, node);
                if (count) {
                    this._size.incrementAndGet();
                }
                return;
            }
            this._tail.compareAndSet(tail, next);
        }
    }

    public QueueConsumerNodeListEntry add(QueueConsumerNode node) {
        QueueConsumerNodeListEntry entry = new QueueConsumerNodeListEntry(this, node);
        this.insert(entry, true);
        return entry;
    }

    boolean removeEntry(QueueConsumerNodeListEntry entry) {
        if (entry.setDeleted()) {
            this._size.decrementAndGet();
            if (this._scavengeCount.incrementAndGet() > this._scavengeCountThreshold) {
                this.scavenge();
            }
            return true;
        }
        return false;
    }

    private void scavenge() {
        this._scavengeCount.set(0);
        for (QueueConsumerNodeListEntry node = this._head; node != null; node = node.findNext()) {
        }
    }

    public QueueConsumerNodeIterator iterator() {
        return new QueueConsumerNodeIterator(this);
    }

    public QueueConsumerNodeListEntry getHead() {
        return this._head;
    }

    public int size() {
        return this._size.get();
    }

    public boolean isEmpty() {
        return this._size.get() == 0;
    }
}

