/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.ExternalAuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.external.ExternalNegotiator;

public class ExternalAuthenticationManagerImpl
extends AbstractAuthenticationManager<ExternalAuthenticationManagerImpl>
implements ExternalAuthenticationManager<ExternalAuthenticationManagerImpl> {
    public static final String MECHANISM_NAME = "EXTERNAL";
    @ManagedAttributeField
    private boolean _useFullDN;

    @ManagedObjectFactoryConstructor
    protected ExternalAuthenticationManagerImpl(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    public boolean getUseFullDN() {
        return this._useFullDN;
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.singletonList(MECHANISM_NAME);
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
        if (MECHANISM_NAME.equals(mechanism)) {
            return new ExternalNegotiator(this, saslSettings.getExternalPrincipal());
        }
        return null;
    }
}

