/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.query.engine.evaluator.SelectEvaluator;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.exception.QueryValidationException;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.AbstractComparisonExpression;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.InExpression;
import org.apache.qpid.server.query.engine.parsing.expression.set.AbstractSetExpression;
import org.apache.qpid.server.query.engine.parsing.expression.set.EmptySetExpression;
import org.apache.qpid.server.query.engine.parsing.factory.LogicExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.query.FromExpression;
import org.apache.qpid.server.query.engine.parsing.query.HavingExpression;
import org.apache.qpid.server.query.engine.parsing.query.ProjectionExpression;

public class SelectExpression<T, R>
extends AbstractSetExpression<T, R> {
    private final List<ProjectionExpression<T, R>> _projections = new ArrayList<ProjectionExpression<T, R>>();
    private final List<ProjectionExpression<T, R>> _groupBy = new ArrayList<ProjectionExpression<T, R>>();
    private final AtomicInteger _ordinal = new AtomicInteger(0);
    private boolean _selectAll = false;
    private FromExpression<T, Stream<?>, ConfiguredObject<?>> _from;
    private ExpressionNode<T, R> _where;
    private HavingExpression<T, R> _having;

    public SelectExpression() {
        super(false);
    }

    public SelectExpression(boolean distinct) {
        super(distinct);
    }

    @Override
    public R apply(T value) {
        if (this.ctx().contains(this.getAlias())) {
            return (R)this.ctx().get(this.getAlias());
        }
        Stream result = new SelectEvaluator().evaluate(this);
        if (this.getParent() == null) {
            return (R)result;
        }
        if (this.getParent() instanceof ProjectionExpression) {
            return this.extractSingleResult(result);
        }
        if (this.getParent() instanceof InExpression) {
            Object collectionResult = this.extractCollectionResult(result);
            this.ctx().put(this.getAlias(), collectionResult);
            return collectionResult;
        }
        if (this.getParent() instanceof AbstractComparisonExpression) {
            Object singleResult = this.extractSingleResult(result);
            this.ctx().put(this.getAlias(), singleResult);
            return singleResult;
        }
        return (R)result;
    }

    private R extractSingleResult(Stream<Map<String, R>> stream) {
        List result = stream.collect(Collectors.toList());
        if (result.isEmpty()) {
            return (R)new EmptySetExpression();
        }
        if (result.size() > 1) {
            throw QueryParsingException.of("Single-row subquery '%s' returns more than one row: %d", String.valueOf(this), result.size());
        }
        Map aggregationMap = (Map)result.get(0);
        if (aggregationMap.keySet().size() > 1) {
            throw QueryParsingException.of("Subquery '%s' returns more than one value: %s", String.valueOf(this), String.valueOf(aggregationMap.keySet()));
        }
        String firstKey = (String)aggregationMap.entrySet().iterator().next().getKey();
        return (R)aggregationMap.get(firstKey);
    }

    private R extractCollectionResult(Stream<Map<String, R>> stream) {
        List result = stream.collect(Collectors.toList());
        ArrayList list = new ArrayList();
        for (Map projection : result) {
            if (projection == null) continue;
            Object firstKey = projection.entrySet().iterator().next().getKey();
            list.add(projection.get(firstKey));
        }
        return (R)list;
    }

    @Override
    public List<ProjectionExpression<T, R>> getProjections() {
        return this._projections;
    }

    public boolean isDistinct() {
        return this._distinct;
    }

    public boolean isSelectAll() {
        return this._selectAll;
    }

    public int getOrdinal() {
        return this._ordinal.incrementAndGet();
    }

    public FromExpression<T, Stream<?>, ConfiguredObject<?>> getFrom() {
        return this._from;
    }

    public Predicate<T> getWhere() {
        return this._where == null ? null : LogicExpressionFactory.toPredicate(this._where);
    }

    public List<ProjectionExpression<T, R>> getGroupBy() {
        return new ArrayList<ProjectionExpression<T, R>>(this._groupBy);
    }

    public HavingExpression<T, R> getHaving() {
        return this._having;
    }

    public void selectAll() {
        this._selectAll = true;
    }

    public void selectItem(ProjectionExpression<T, R> expression) {
        this._projections.add(expression);
    }

    public void distinct(boolean distinct) {
        this._distinct = distinct;
    }

    public void from(String domain, String alias) {
        if (this._from != null) {
            throw QueryValidationException.of("Querying from multiple domains not supported", new Object[0]);
        }
        this._from = new FromExpression(domain, alias);
    }

    public void join() {
        throw QueryValidationException.of("Joins are not supported", new Object[0]);
    }

    public void where(ExpressionNode<T, R> predicate) {
        this._where = predicate;
    }

    public void having(ExpressionNode<T, R> predicate) {
        this._having = new HavingExpression<T, R>(this, predicate);
    }

    public void groupBy(ProjectionExpression<T, R> expression) {
        if (expression.isOrdinal()) {
            int ordinal = (Integer)expression.apply(null) - 1;
            if (ordinal < 0 || ordinal >= this._projections.size()) {
                throw QueryParsingException.of("Group by item must be the number of a select list expression", new Object[0]);
            }
            this._groupBy.add(this._projections.get(ordinal));
        } else {
            this._groupBy.add(expression);
        }
    }

    public void resetOrdinal() {
        this._ordinal.set(0);
    }

    public boolean hasAggregationItems() {
        return this._projections.stream().anyMatch(AbstractExpressionNode::containsAggregation);
    }

    public List<ProjectionExpression<T, R>> getAggregationItems() {
        return this._projections.stream().filter(AbstractExpressionNode::containsAggregation).collect(Collectors.toList());
    }

    @Override
    public String getAlias() {
        return "select " + (this._distinct ? " distinct " : "") + (this._selectAll ? " * " : "") + this._projections.stream().map(AbstractExpressionNode::toString).collect(Collectors.joining(", ")) + (String)(this._from == null ? "" : " from " + this._from.getAlias()) + (String)(this._where == null ? "" : " where " + this._where.getAlias()) + this._groupBy.stream().map(AbstractExpressionNode::getAlias).collect(Collectors.joining(", ")) + (this._having == null ? "" : this._having.getAlias());
    }

    @Override
    public String toString() {
        return this.getAlias();
    }
}

