/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.kms.dao.DaoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerKMSDB {
    private static final Logger logger = LoggerFactory.getLogger(RangerKMSDB.class);
    private static final String PROPERTY_PREFIX = "ranger.ks.";
    private static final String DB_DIALECT = "jpa.jdbc.dialect";
    private static final String DB_DRIVER = "jpa.jdbc.driver";
    private static final String DB_URL = "jpa.jdbc.url";
    private static final String DB_USER = "jpa.jdbc.user";
    private static final String DB_PASSWORD = "jpa.jdbc.password";
    private static final String JPA_DB_DIALECT = "javax.persistence.jdbc.dialect";
    private static final String JPA_DB_DRIVER = "javax.persistence.jdbc.driver";
    private static final String JPA_DB_URL = "javax.persistence.jdbc.url";
    private static final String JPA_DB_USER = "javax.persistence.jdbc.user";
    private static final String JPA_DB_PASSWORD = "javax.persistence.jdbc.password";
    private static final String DB_SSL_ENABLED = "db.ssl.enabled";
    private static final String DB_SSL_REQUIRED = "db.ssl.required";
    private static final String DB_SSL_VerifyServerCertificate = "db.ssl.verifyServerCertificate";
    private static final String DB_SSL_AUTH_TYPE = "db.ssl.auth.type";
    private static final String DB_SSL_KEYSTORE = "keystore.file";
    private static final String DB_SSL_KEYSTORE_PASSWORD = "keystore.password";
    private static final String DB_SSL_TRUSTSTORE = "truststore.file";
    private static final String DB_SSL_TRUSTSTORE_PASSWORD = "truststore.password";
    private static final String DB_SSL_CERTIFICATE_FILE = "db.ssl.certificateFile";
    public static final int DB_FLAVOR_UNKNOWN = 0;
    public static final int DB_FLAVOR_MYSQL = 1;
    public static final int DB_FLAVOR_ORACLE = 2;
    public static final int DB_FLAVOR_POSTGRES = 3;
    public static final int DB_FLAVOR_SQLSERVER = 4;
    public static final int DB_FLAVOR_SQLANYWHERE = 5;
    private final Configuration conf;
    private final Map<String, String> jpaProperties = new HashMap<String, String>();
    private final DaoManager daoManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangerKMSDB(Configuration conf) {
        this.conf = conf;
        DaoManager daoManager = null;
        try {
            this.jpaProperties.put(JPA_DB_DIALECT, conf.get("ranger.ks.jpa.jdbc.dialect"));
            this.jpaProperties.put(JPA_DB_DRIVER, conf.get("ranger.ks.jpa.jdbc.driver"));
            this.jpaProperties.put(JPA_DB_URL, conf.get("ranger.ks.jpa.jdbc.url"));
            this.jpaProperties.put(JPA_DB_USER, conf.get("ranger.ks.jpa.jdbc.user"));
            this.jpaProperties.put(JPA_DB_PASSWORD, conf.get("ranger.ks.jpa.jdbc.password"));
            int dbFlavor = this.getDBFlavor(conf);
            if (dbFlavor == 1 || dbFlavor == 3) {
                this.updateDBSSLURL();
            }
            EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"persistence_ranger_server", this.jpaProperties);
            daoManager = new DaoManager(entityManagerFactory);
            daoManager.getEntityManager();
            logger.info("Connected to DB : " + this.isDbConnected());
        }
        catch (Exception excp) {
            logger.error("initDBConnectivity() failed", (Throwable)excp);
        }
        finally {
            this.daoManager = daoManager;
        }
    }

    public DaoManager getDaoManager() {
        return this.daoManager;
    }

    private boolean isDbConnected() {
        EntityManager em = this.getEntityManager();
        return em != null && em.isOpen();
    }

    private EntityManager getEntityManager() {
        DaoManager daoMgr = this.daoManager;
        if (daoMgr != null) {
            try {
                return daoMgr.getEntityManager();
            }
            catch (Exception excp) {
                logger.error("getEntityManager() failed", (Throwable)excp);
            }
        }
        return null;
    }

    private int getDBFlavor(Configuration newConfig) {
        String[] propertyNames;
        for (String propertyName : propertyNames = new String[]{"ranger.ks.jpa.jdbc.dialect", "ranger.ks.jpa.jdbc.driver", "ranger.ks.jpa.jdbc.url"}) {
            String propertyValue = newConfig.get(propertyName);
            if (StringUtils.isBlank((CharSequence)propertyValue)) continue;
            if (StringUtils.containsIgnoreCase((CharSequence)propertyValue, (CharSequence)"mysql")) {
                return 1;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)propertyValue, (CharSequence)"oracle")) {
                return 2;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)propertyValue, (CharSequence)"postgresql")) {
                return 3;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)propertyValue, (CharSequence)"sqlserver")) {
                return 4;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)propertyValue, (CharSequence)"mssql")) {
                return 4;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)propertyValue, (CharSequence)"sqlanywhere")) {
                return 5;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)propertyValue, (CharSequence)"sqla")) {
                return 5;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("DB Flavor could not be determined from property - " + propertyName + "=" + propertyValue);
        }
        logger.error("DB Flavor could not be determined");
        return 0;
    }

    private void updateDBSSLURL() {
        String db_ssl_enabled;
        if (this.conf != null && this.conf.get("ranger.ks.db.ssl.enabled") != null && "true".equalsIgnoreCase(db_ssl_enabled = this.normalize(this.conf.get("ranger.ks.db.ssl.enabled")))) {
            String db_ssl_required = this.normalize(this.conf.get("ranger.ks.db.ssl.required"));
            String db_ssl_verifyServerCertificate = this.normalize(this.conf.get("ranger.ks.db.ssl.verifyServerCertificate"));
            String db_ssl_auth_type = this.conf.get("ranger.ks.db.ssl.auth.type", "2-way");
            this.conf.set("ranger.ks.db.ssl.enabled", db_ssl_enabled);
            this.conf.set("ranger.ks.db.ssl.required", db_ssl_required);
            this.conf.set("ranger.ks.db.ssl.verifyServerCertificate", db_ssl_verifyServerCertificate);
            this.conf.set("ranger.ks.db.ssl.auth.type", db_ssl_auth_type);
            String ranger_jpa_jdbc_url = this.conf.get("ranger.ks.jpa.jdbc.url");
            if (StringUtils.isNotEmpty((CharSequence)ranger_jpa_jdbc_url) && !ranger_jpa_jdbc_url.contains("?")) {
                StringBuilder ranger_jpa_jdbc_url_ssl = new StringBuilder(ranger_jpa_jdbc_url);
                int dbFlavor = this.getDBFlavor(this.conf);
                if (dbFlavor == 1) {
                    ranger_jpa_jdbc_url_ssl.append("?useSSL=").append(db_ssl_enabled).append("&requireSSL=").append(db_ssl_required).append("&verifyServerCertificate=").append(db_ssl_verifyServerCertificate);
                } else if (dbFlavor == 3) {
                    String db_ssl_certificate_file = this.conf.get("ranger.ks.db.ssl.certificateFile");
                    if (StringUtils.isNotEmpty((CharSequence)db_ssl_certificate_file)) {
                        ranger_jpa_jdbc_url_ssl.append("?ssl=").append(db_ssl_enabled).append("&sslmode=verify-full").append("&sslrootcert=").append(db_ssl_certificate_file);
                    } else if ("true".equalsIgnoreCase(db_ssl_verifyServerCertificate) || "true".equalsIgnoreCase(db_ssl_required)) {
                        ranger_jpa_jdbc_url_ssl.append("?ssl=").append(db_ssl_enabled).append("&sslmode=verify-full").append("&sslfactory=org.postgresql.ssl.DefaultJavaSSLFactory");
                    } else {
                        ranger_jpa_jdbc_url_ssl.append("?ssl=").append(db_ssl_enabled);
                    }
                }
                this.conf.set("ranger.ks.jpa.jdbc.url", ranger_jpa_jdbc_url_ssl.toString());
            }
            this.jpaProperties.put(JPA_DB_URL, this.conf.get("ranger.ks.jpa.jdbc.url"));
            logger.info("ranger.ks.jpa.jdbc.url=" + this.conf.get("ranger.ks.jpa.jdbc.url"));
            if ("true".equalsIgnoreCase(db_ssl_verifyServerCertificate) || "true".equalsIgnoreCase(db_ssl_required)) {
                String truststore;
                if (!"1-way".equalsIgnoreCase(db_ssl_auth_type)) {
                    String keystore = this.conf.get("ranger.ks.keystore.file");
                    if (!StringUtils.isEmpty((CharSequence)keystore)) {
                        Path path = Paths.get(keystore, new String[0]);
                        if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path)) {
                            System.setProperty("javax.net.ssl.keyStore", this.conf.get("ranger.ks.keystore.file"));
                            System.setProperty("javax.net.ssl.keyStorePassword", this.conf.get("ranger.ks.keystore.password"));
                            System.setProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
                        } else {
                            logger.debug("Could not find or read keystore file '{}'", (Object)keystore);
                        }
                    } else {
                        logger.debug("keystore property '{}' value not found!", (Object)"ranger.ks.keystore.file");
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)(truststore = this.conf.get("ranger.ks.truststore.file")))) {
                    Path path = Paths.get(truststore, new String[0]);
                    if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path)) {
                        System.setProperty("javax.net.ssl.trustStore", this.conf.get("ranger.ks.truststore.file"));
                        System.setProperty("javax.net.ssl.trustStorePassword", this.conf.get("ranger.ks.truststore.password"));
                        System.setProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                    } else {
                        logger.debug("Could not find or read truststore file '{}'", (Object)truststore);
                    }
                } else {
                    logger.debug("truststore property '{}' value not found!", (Object)"ranger.ks.truststore.file");
                }
            }
        }
    }

    private String normalize(String booleanFlag) {
        if (StringUtils.isEmpty((CharSequence)booleanFlag) || !"true".equalsIgnoreCase(booleanFlag)) {
            return "false";
        }
        return booleanFlag.toLowerCase();
    }
}

