/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.embedded;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.audit.provider.AuditProviderFactory;
import org.apache.ranger.authz.api.RangerAuthorizer;
import org.apache.ranger.authz.api.RangerAuthzApiErrorCode;
import org.apache.ranger.authz.api.RangerAuthzErrorCode;
import org.apache.ranger.authz.api.RangerAuthzException;
import org.apache.ranger.authz.embedded.RangerAuthzAuditHandler;
import org.apache.ranger.authz.embedded.RangerAuthzConfig;
import org.apache.ranger.authz.embedded.RangerAuthzPlugin;
import org.apache.ranger.authz.embedded.RangerEmbeddedAuthzErrorCode;
import org.apache.ranger.authz.model.RangerAccessContext;
import org.apache.ranger.authz.model.RangerAccessInfo;
import org.apache.ranger.authz.model.RangerAuthzRequest;
import org.apache.ranger.authz.model.RangerAuthzResult;
import org.apache.ranger.authz.model.RangerMultiAuthzRequest;
import org.apache.ranger.authz.model.RangerMultiAuthzResult;
import org.apache.ranger.authz.model.RangerResourceInfo;
import org.apache.ranger.authz.model.RangerResourcePermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerEmbeddedAuthorizer
extends RangerAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerEmbeddedAuthorizer.class);
    private final RangerAuthzConfig config;
    private final Map<String, RangerAuthzPlugin> plugins = new HashMap<String, RangerAuthzPlugin>();

    public RangerEmbeddedAuthorizer(Properties properties) {
        super(properties);
        this.config = new RangerAuthzConfig(properties);
    }

    public void init() throws RangerAuthzException {
        String[] initServices;
        AuditProviderFactory.getInstance().init(this.config.getAuditProperties(), "ranger-authz");
        for (String serviceName : initServices = this.config.getInitServices()) {
            String serviceType = this.config.getServiceTypeForService(serviceName);
            this.getOrCreatePlugin(serviceName, serviceType);
        }
    }

    public void close() {
        for (RangerAuthzPlugin plugin : this.plugins.values()) {
            plugin.cleanup();
        }
        this.plugins.clear();
    }

    public RangerAuthzResult authorize(RangerAuthzRequest request) throws RangerAuthzException {
        this.validateRequest(request);
        RangerAuthzPlugin plugin = this.getOrCreatePlugin(request.getContext().getServiceName(), request.getContext().getServiceType());
        try (RangerAuthzAuditHandler auditHandler = new RangerAuthzAuditHandler(plugin.getPlugin());){
            RangerAuthzResult rangerAuthzResult = this.authorize(request, plugin, auditHandler);
            return rangerAuthzResult;
        }
    }

    public RangerMultiAuthzResult authorize(RangerMultiAuthzRequest request) throws RangerAuthzException {
        this.validateRequest(request);
        RangerAuthzPlugin plugin = this.getOrCreatePlugin(request.getContext().getServiceName(), request.getContext().getServiceType());
        RangerMultiAuthzResult result = new RangerMultiAuthzResult(request.getRequestId());
        if (request.getAccesses() != null) {
            int allowedCount = 0;
            int deniedCount = 0;
            int notDeterminedCount = 0;
            result.setAccesses(new ArrayList(request.getAccesses().size()));
            try (RangerAuthzAuditHandler auditHandler = new RangerAuthzAuditHandler(plugin.getPlugin());){
                for (RangerAccessInfo accessInfo : request.getAccesses()) {
                    RangerAuthzRequest authzRequest = new RangerAuthzRequest(null, request.getUser(), accessInfo, request.getContext());
                    RangerAuthzResult authzResult = this.authorize(authzRequest, plugin, auditHandler);
                    if (authzResult.getDecision() == RangerAuthzResult.AccessDecision.ALLOW) {
                        ++allowedCount;
                    } else if (authzResult.getDecision() == RangerAuthzResult.AccessDecision.DENY) {
                        ++deniedCount;
                    } else if (authzResult.getDecision() == RangerAuthzResult.AccessDecision.NOT_DETERMINED) {
                        ++notDeterminedCount;
                    }
                    result.getAccesses().add(authzResult);
                }
            }
            if (allowedCount == request.getAccesses().size()) {
                result.setDecision(RangerAuthzResult.AccessDecision.ALLOW);
            } else if (deniedCount == request.getAccesses().size()) {
                result.setDecision(RangerAuthzResult.AccessDecision.DENY);
            } else if (notDeterminedCount == request.getAccesses().size()) {
                result.setDecision(RangerAuthzResult.AccessDecision.NOT_DETERMINED);
            } else {
                result.setDecision(RangerAuthzResult.AccessDecision.PARTIAL);
            }
        }
        return result;
    }

    public RangerResourcePermissions getResourcePermissions(RangerResourceInfo resource, RangerAccessContext context) throws RangerAuthzException {
        this.validateAccessContext(context);
        RangerAuthzPlugin plugin = this.getOrCreatePlugin(context.getServiceName(), context.getServiceType());
        return plugin.getResourcePermissions(resource, context);
    }

    protected void validateAccessContext(RangerAccessContext context) throws RangerAuthzException {
        super.validateAccessContext(context);
        String serviceName = context.getServiceName();
        String serviceType = context.getServiceType();
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            if (StringUtils.isBlank((CharSequence)serviceType)) {
                throw new RangerAuthzException((RangerAuthzErrorCode)RangerAuthzApiErrorCode.INVALID_REQUEST_SERVICE_NAME_OR_TYPE_MANDATORY);
            }
            serviceName = this.config.getDefaultServiceNameForServiceType(serviceType);
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                throw new RangerAuthzException((RangerAuthzErrorCode)RangerEmbeddedAuthzErrorCode.NO_DEFAULT_SERVICE_FOR_SERVICE_TYPE, new Object[]{serviceName});
            }
            context.setServiceName(serviceName);
        }
        if (StringUtils.isBlank((CharSequence)serviceType)) {
            serviceType = this.config.getServiceTypeForService(serviceName);
            if (StringUtils.isBlank((CharSequence)serviceType)) {
                throw new RangerAuthzException((RangerAuthzErrorCode)RangerEmbeddedAuthzErrorCode.NO_SERVICE_TYPE_FOR_SERVICE, new Object[]{serviceName});
            }
            context.setServiceType(serviceType);
        }
    }

    private RangerAuthzResult authorize(RangerAuthzRequest request, RangerAuthzPlugin plugin, RangerAuthzAuditHandler auditHandler) throws RangerAuthzException {
        return plugin.authorize(request, auditHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RangerAuthzPlugin getOrCreatePlugin(String serviceName, String serviceType) throws RangerAuthzException {
        RangerAuthzPlugin ret = this.plugins.get(serviceName);
        if (ret == null) {
            Map<String, RangerAuthzPlugin> map = this.plugins;
            synchronized (map) {
                ret = this.plugins.get(serviceName);
                if (ret == null) {
                    Properties pluginProperties = this.config.getServiceProperties(serviceName, serviceType);
                    LOG.debug("properties for service {}: {}", (Object)serviceName, (Object)pluginProperties);
                    ret = new RangerAuthzPlugin(serviceType, serviceName, pluginProperties);
                    this.plugins.put(serviceName, ret);
                }
            }
        }
        return ret;
    }
}

