/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.keyvault.Vaults;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManagementClientImpl;
import com.microsoft.azure.management.keyvault.implementation.VaultsImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

public final class KeyVaultManager
extends Manager<KeyVaultManager, KeyVaultManagementClientImpl> {
    private GraphRbacManager graphRbacManager;
    private Vaults vaults;
    private final String tenantId;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static KeyVaultManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new KeyVaultManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), credentials.domain(), subscriptionId);
    }

    public static KeyVaultManager authenticate(RestClient restClient, String tenantId, String subscriptionId) {
        return new KeyVaultManager(restClient, tenantId, subscriptionId);
    }

    private KeyVaultManager(RestClient restClient, String tenantId, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new KeyVaultManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
        this.graphRbacManager = GraphRbacManager.authenticate((RestClient)restClient, (String)tenantId);
        this.tenantId = tenantId;
    }

    public Vaults vaults() {
        if (this.vaults == null) {
            this.vaults = new VaultsImpl(this, this.graphRbacManager, this.tenantId);
        }
        return this.vaults;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public KeyVaultManager authenticate(AzureTokenCredentials credentials, String tenantId, String subscriptionId) {
            return KeyVaultManager.authenticate(this.buildRestClient(credentials, AzureEnvironment.Endpoint.RESOURCE_MANAGER), tenantId, subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public KeyVaultManager authenticate(AzureTokenCredentials var1, String var2, String var3);
    }
}

