/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NetworkSecurityGroups;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupImpl;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupInner;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import java.util.Set;
import rx.Completable;

@LangDefinition
class NetworkSecurityGroupsImpl
extends TopLevelModifiableResourcesImpl<NetworkSecurityGroup, NetworkSecurityGroupImpl, NetworkSecurityGroupInner, NetworkSecurityGroupsInner, NetworkManager>
implements NetworkSecurityGroups {
    NetworkSecurityGroupsImpl(NetworkManager networkManager) {
        super((InnerSupportsListing)((NetworkManagementClientImpl)((Object)networkManager.inner())).networkSecurityGroups(), (ManagerBase)networkManager);
    }

    public Completable deleteByResourceGroupAsync(String groupName, String name) {
        Set<String> nicIds;
        NetworkSecurityGroupImpl nsg = (NetworkSecurityGroupImpl)this.getByResourceGroup(groupName, name);
        if (nsg != null && (nicIds = nsg.networkInterfaceIds()) != null) {
            for (String nicRef : nsg.networkInterfaceIds()) {
                NetworkInterface nic = (NetworkInterface)((NetworkManager)this.manager()).networkInterfaces().getById(nicRef);
                if (nic == null || !nsg.id().equalsIgnoreCase(nic.networkSecurityGroupId())) continue;
                ((NetworkInterface.Update)nic.update()).withoutNetworkSecurityGroup().apply();
            }
        }
        return this.deleteInnerAsync(groupName, name);
    }

    public NetworkSecurityGroupImpl define(String name) {
        return this.wrapModel(name);
    }

    protected NetworkSecurityGroupImpl wrapModel(String name) {
        NetworkSecurityGroupInner inner = new NetworkSecurityGroupInner();
        return new NetworkSecurityGroupImpl(name, inner, (NetworkManager)this.manager());
    }

    protected NetworkSecurityGroupImpl wrapModel(NetworkSecurityGroupInner inner) {
        if (inner == null) {
            return null;
        }
        return new NetworkSecurityGroupImpl(inner.name(), inner, (NetworkManager)this.manager());
    }
}

