/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.CreationData;
import com.microsoft.azure.management.compute.CreationSourceType;
import com.microsoft.azure.management.compute.DiskCreateOption;
import com.microsoft.azure.management.compute.ImageDiskReference;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Compute.Fluent.Models")
public class CreationSource {
    private final CreationData creationData;

    public CreationSource(CreationData creationData) {
        this.creationData = creationData;
    }

    public CreationSourceType type() {
        DiskCreateOption createOption = this.creationData.createOption();
        if (createOption == DiskCreateOption.FROM_IMAGE) {
            ImageDiskReference imageReference = this.creationData.imageReference();
            if (imageReference.lun() == null) {
                return CreationSourceType.FROM_OS_DISK_IMAGE;
            }
            return CreationSourceType.FROM_DATA_DISK_IMAGE;
        }
        if (createOption == DiskCreateOption.IMPORT) {
            return CreationSourceType.IMPORTED_FROM_VHD;
        }
        if (createOption == DiskCreateOption.COPY) {
            String resourceType;
            String sourceResourceId = this.creationData.sourceResourceId();
            if (sourceResourceId != null) {
                resourceType = ResourceUtils.resourceTypeFromResourceId((String)sourceResourceId);
                if (resourceType.equalsIgnoreCase("disks")) {
                    return CreationSourceType.COPIED_FROM_DISK;
                }
                if (resourceType.equalsIgnoreCase("snapshots")) {
                    return CreationSourceType.COPIED_FROM_SNAPSHOT;
                }
            }
            if (this.creationData.sourceUri() != null) {
                sourceResourceId = this.creationData.sourceUri();
                resourceType = ResourceUtils.resourceTypeFromResourceId((String)sourceResourceId);
                if (resourceType.equalsIgnoreCase("disks")) {
                    return CreationSourceType.COPIED_FROM_DISK;
                }
                if (resourceType.equalsIgnoreCase("snapshots")) {
                    return CreationSourceType.COPIED_FROM_SNAPSHOT;
                }
            }
        }
        if (createOption == DiskCreateOption.EMPTY) {
            return CreationSourceType.EMPTY;
        }
        return CreationSourceType.UNKNOWN;
    }

    public String sourceId() {
        if (this.type() == CreationSourceType.FROM_OS_DISK_IMAGE || this.type() == CreationSourceType.FROM_DATA_DISK_IMAGE) {
            return this.creationData.imageReference().id();
        }
        if (this.type() == CreationSourceType.IMPORTED_FROM_VHD) {
            return this.creationData.sourceUri();
        }
        if (this.type() == CreationSourceType.COPIED_FROM_DISK) {
            String sourceResourceId = this.creationData.sourceResourceId();
            if (sourceResourceId == null) {
                sourceResourceId = this.creationData.sourceUri();
            }
            return sourceResourceId;
        }
        if (this.type() == CreationSourceType.COPIED_FROM_SNAPSHOT) {
            String sourceResourceId = this.creationData.sourceResourceId();
            if (sourceResourceId == null) {
                sourceResourceId = this.creationData.sourceUri();
            }
            return sourceResourceId;
        }
        return null;
    }

    public int sourceDataDiskImageLun() {
        if (this.type() == CreationSourceType.FROM_DATA_DISK_IMAGE) {
            return this.creationData.imageReference().lun();
        }
        return -1;
    }
}

