/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.resources.implementation.PolicyAssignmentsInner;
import com.microsoft.azure.management.resources.implementation.PolicyDefinitionsInner;
import com.microsoft.azure.management.resources.implementation.PolicySetDefinitionsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class PolicyClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private PolicyAssignmentsInner policyAssignments;
    private PolicySetDefinitionsInner policySetDefinitions;
    private PolicyDefinitionsInner policyDefinitions;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public PolicyClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public PolicyClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public PolicyClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public PolicyClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public PolicyAssignmentsInner policyAssignments() {
        return this.policyAssignments;
    }

    public PolicySetDefinitionsInner policySetDefinitions() {
        return this.policySetDefinitions;
    }

    public PolicyDefinitionsInner policyDefinitions() {
        return this.policyDefinitions;
    }

    public PolicyClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public PolicyClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public PolicyClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.policyAssignments = new PolicyAssignmentsInner(this.restClient().retrofit(), this);
        this.policySetDefinitions = new PolicySetDefinitionsInner(this.restClient().retrofit(), this);
        this.policyDefinitions = new PolicyDefinitionsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "PolicyClient");
    }
}

