/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.contextenricher.RangerTagRetriever;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerFileBasedTagRetriever
extends RangerTagRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(RangerFileBasedTagRetriever.class);
    private URL serviceTagsFileURL;
    private String serviceTagsFileName;
    int tagFilesCount = 0;
    int currentTagFileIndex = 0;
    boolean isInitial = true;

    @Override
    public void init(Map<String, String> options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> init()");
        }
        String serviceTagsFileNameProperty = "serviceTagsFileName";
        String serviceTagsDefaultFileName = "/testdata/test_servicetags_hive.json";
        String tagFilesCountProperty = "tagFileCount";
        if (StringUtils.isNotBlank((CharSequence)this.serviceName) && this.serviceDef != null && StringUtils.isNotBlank((CharSequence)this.appId)) {
            String tagFilesCountStr;
            this.serviceTagsFileName = options != null ? options.get(serviceTagsFileNameProperty) : null;
            String string = this.serviceTagsFileName = this.serviceTagsFileName == null ? serviceTagsDefaultFileName : this.serviceTagsFileName;
            if (options != null && !StringUtils.isNotEmpty((CharSequence)(tagFilesCountStr = options.get(tagFilesCountProperty)))) {
                try {
                    this.tagFilesCount = Integer.parseInt(tagFilesCountStr);
                }
                catch (Exception e) {
                    LOG.error("Exception while parsing tagFileCount option value:[" + tagFilesCountStr + "]");
                    LOG.error("Setting tagFilesCount to 0");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.serviceTagsFileName)) {
                this.serviceTagsFileURL = this.getTagFileURL(this.serviceTagsFileName);
            }
            this.isInitial = true;
        } else {
            LOG.error("FATAL: Cannot find service/serviceDef/serviceTagsFile to use for retrieving tags. Will NOT be able to retrieve tags.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== init() : serviceTagsFileName=" + this.serviceTagsFileName);
        }
    }

    @Override
    public ServiceTags retrieveTags(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> retrieveTags(lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis + ", serviceTagsFilePath=" + this.serviceTagsFileName);
        }
        ServiceTags serviceTags = this.readFromFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== retrieveTags(lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
        }
        return serviceTags;
    }

    URL getTagFileURL(String fileName) {
        URL fileURL = null;
        InputStream tagFileStream = null;
        File f = new File(fileName);
        if (f.exists() && f.isFile() && f.canRead()) {
            try {
                tagFileStream = new FileInputStream(f);
                fileURL = f.toURI().toURL();
            }
            catch (FileNotFoundException exception) {
                LOG.error("Error processing input file:" + fileName + " or no privilege for reading file " + fileName, (Throwable)exception);
            }
            catch (MalformedURLException malformedException) {
                LOG.error("Error processing input file:" + fileName + " cannot be converted to URL " + fileName, (Throwable)malformedException);
            }
        } else {
            fileURL = this.getClass().getResource(fileName);
            if (fileURL == null && !fileName.startsWith("/")) {
                fileURL = this.getClass().getResource("/" + fileName);
            }
            if (fileURL == null && (fileURL = ClassLoader.getSystemClassLoader().getResource(fileName)) == null && !fileName.startsWith("/")) {
                fileURL = ClassLoader.getSystemClassLoader().getResource("/" + fileName);
            }
            if (fileURL != null) {
                try {
                    tagFileStream = fileURL.openStream();
                }
                catch (Exception exception) {
                    fileURL = null;
                    LOG.error(fileName + " is not a file", (Throwable)exception);
                }
            } else {
                LOG.warn("Error processing input file: URL not found for " + fileName + " or no privilege for reading file " + fileName);
            }
        }
        if (tagFileStream != null) {
            try {
                tagFileStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fileURL;
    }

    private ServiceTags readFromFile() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerFileBasedTagRetriever.readFromFile: sourceFileName=" + this.serviceTagsFileName);
        }
        ServiceTags ret = null;
        String fileName = this.serviceTagsFileName;
        if (this.isInitial) {
            this.isInitial = false;
            if (this.serviceTagsFileURL != null) {
                try (InputStream fileStream = this.serviceTagsFileURL.openStream();
                     InputStreamReader reader = new InputStreamReader(fileStream, StandardCharsets.UTF_8);){
                    ret = JsonUtils.jsonToObject(reader, ServiceTags.class);
                    if (ret.getIsTagsDeduped().booleanValue()) {
                        int countOfDuplicateTags = ret.dedupTags();
                        LOG.info("Number of duplicate tags removed from the received serviceTags:[" + countOfDuplicateTags + "]. Number of tags in the de-duplicated serviceTags :[" + ret.getTags().size() + "].");
                    }
                }
                catch (IOException e) {
                    LOG.warn("Error processing input file: or no privilege for reading file " + fileName, (Throwable)e);
                }
            } else {
                LOG.error("Error reading file: " + fileName);
            }
        } else if (this.tagFilesCount > 0) {
            this.currentTagFileIndex %= this.tagFilesCount;
            fileName = this.serviceTagsFileName + "_" + this.currentTagFileIndex + ".json";
            URL fileURL = this.getTagFileURL(fileName);
            if (fileURL != null) {
                try (InputStream fileStream = fileURL.openStream();
                     InputStreamReader reader = new InputStreamReader(fileStream, StandardCharsets.UTF_8);){
                    ret = JsonUtils.jsonToObject(reader, ServiceTags.class);
                    ++this.currentTagFileIndex;
                    if (ret.getIsTagsDeduped().booleanValue()) {
                        int countOfDuplicateTags = ret.dedupTags();
                        LOG.info("Number of duplicate tags removed from the received serviceTags:[" + countOfDuplicateTags + "]. Number of tags in the de-duplicated serviceTags :[" + ret.getTags().size() + "].");
                    }
                }
                catch (IOException e) {
                    LOG.warn("Error processing input file: or no privilege for reading file " + fileName, (Throwable)e);
                }
            } else {
                LOG.error("Error reading file: " + fileName);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerFileBasedTagRetriever.readFromFile: sourceFileName=" + fileName);
        }
        return ret;
    }
}

