/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.model.RangerSecurityZone;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetailsBuilder;
import org.apache.ranger.plugin.store.RoleStore;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.RangerObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerValidator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerValidator.class);
    RoleStore _roleStore;
    ServiceStore _store;
    RangerObjectFactory _factory = new RangerObjectFactory();

    protected RangerValidator(ServiceStore store) {
        if (store == null) {
            throw new IllegalArgumentException("ServiceValidator(): store is null!");
        }
        this._store = store;
    }

    protected RangerValidator(RoleStore roleStore) {
        if (roleStore == null) {
            throw new IllegalArgumentException("ServiceValidator(): store is null!");
        }
        this._roleStore = roleStore;
    }

    public void validate(Long id, Action action) throws Exception {
        ArrayList<ValidationFailureDetails> failures;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.validate(" + id + ")");
        }
        if (this.isValid(id, action, failures = new ArrayList<ValidationFailureDetails>())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerValidator.validate(" + id + "): valid");
            }
        } else {
            String message = RangerValidator.serializeFailures(failures);
            LOG.debug("<== RangerValidator.validate(" + id + "): invalid, reason[" + message + "]");
            throw new Exception(message);
        }
    }

    public void validate(String name, Action action) throws Exception {
        ArrayList<ValidationFailureDetails> failures;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.validate(" + name + ")");
        }
        if (this.isValid(name, action, failures = new ArrayList<ValidationFailureDetails>())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerValidator.validate(" + name + "): valid");
            }
        } else {
            String message = RangerValidator.serializeFailures(failures);
            LOG.debug("<== RangerValidator.validate(" + name + "): invalid, reason[" + message + "]");
            throw new Exception(message);
        }
    }

    boolean isValid(Long id, Action action, List<ValidationFailureDetails> failures) {
        failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf("unimplemented method called").build());
        return false;
    }

    boolean isValid(String name, Action action, List<ValidationFailureDetails> failures) {
        failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf("unimplemented method called").build());
        return false;
    }

    public static String serializeFailures(List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getFailureMessage()");
        }
        String message = null;
        if (CollectionUtils.isEmpty(failures)) {
            LOG.warn("serializeFailures: called while list of failures is null/empty!");
        } else {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < failures.size(); ++i) {
                builder.append(String.format("(%d)", i));
                builder.append(failures.get(i));
                builder.append(" ");
            }
            message = builder.toString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.serializeFailures(): " + message);
        }
        return message;
    }

    Set<String> getServiceConfigParameters(RangerService service) {
        if (service == null || service.getConfigs() == null) {
            return new HashSet<String>();
        }
        return service.getConfigs().keySet();
    }

    Set<String> getRequiredParameters(RangerServiceDef serviceDef) {
        Set<String> result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getRequiredParameters(" + serviceDef + ")");
        }
        if (serviceDef == null) {
            result = Collections.emptySet();
        } else {
            List<RangerServiceDef.RangerServiceConfigDef> configs = serviceDef.getConfigs();
            if (CollectionUtils.isEmpty(configs)) {
                result = Collections.emptySet();
            } else {
                result = new HashSet<String>(configs.size());
                for (RangerServiceDef.RangerServiceConfigDef configDef : configs) {
                    if (!configDef.getMandatory().booleanValue()) continue;
                    result.add(configDef.getName());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getRequiredParameters(" + serviceDef + "): " + result);
        }
        return result;
    }

    RangerServiceDef getServiceDef(Long id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getServiceDef(" + id + ")");
        }
        RangerServiceDef result = null;
        try {
            result = this._store.getServiceDef(id);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving service def from service store!", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getServiceDef(" + id + "): " + result);
        }
        return result;
    }

    RangerServiceDef getServiceDef(String type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getServiceDef(" + type + ")");
        }
        RangerServiceDef result = null;
        try {
            result = this._store.getServiceDefByName(type);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving service definition from service store!", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getServiceDef(" + type + "): " + result);
        }
        return result;
    }

    RangerServiceDef getServiceDefByDisplayName(String displayName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getServiceDefByDisplayName(" + displayName + ")");
        }
        RangerServiceDef result = null;
        try {
            result = this._store.getServiceDefByDisplayName(displayName);
        }
        catch (Exception e) {
            LOG.debug("Encountered exception while retrieving service definition from service store!", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getServiceDefByDisplayName(" + displayName + "): " + result);
        }
        return result;
    }

    RangerService getService(Long id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getService(" + id + ")");
        }
        RangerService result = null;
        try {
            result = this._store.getService(id);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving service from service store!", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getService(" + id + "): " + result);
        }
        return result;
    }

    RangerService getService(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getService(" + name + ")");
        }
        RangerService result = null;
        try {
            result = this._store.getServiceByName(name);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving service from service store!", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getService(" + name + "): " + result);
        }
        return result;
    }

    RangerService getServiceByDisplayName(String displayName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getService(" + displayName + ")");
        }
        RangerService result = null;
        try {
            result = this._store.getServiceByDisplayName(displayName);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving service from service store!", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getService(" + displayName + "): " + result);
        }
        return result;
    }

    boolean policyExists(Long id) {
        try {
            return this._store.policyExists(id);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving policy from service store!", (Throwable)e);
            return false;
        }
    }

    RangerPolicy getPolicy(Long id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getPolicy(" + id + ")");
        }
        RangerPolicy result = null;
        try {
            result = this._store.getPolicy(id);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving policy from service store!", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getPolicy(" + id + "): " + result);
        }
        return result;
    }

    Long getPolicyId(Long serviceId, String policyName, Long zoneId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getPolicyId(" + serviceId + ", " + policyName + ", " + zoneId + ")");
        }
        Long policyId = this._store.getPolicyId(serviceId, policyName, zoneId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getPolicyId(" + serviceId + ", " + policyName + ", " + zoneId + "): policy-id[" + policyId + "]");
        }
        return policyId;
    }

    List<RangerPolicy> getPoliciesForResourceSignature(String serviceName, String policySignature) {
        ArrayList<RangerPolicy> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerValidator.getPoliciesForResourceSignature(%s, %s)", serviceName, policySignature));
        }
        List<Object> enabledPolicies = new ArrayList();
        List<RangerPolicy> disabledPolicies = new ArrayList<RangerPolicy>();
        try {
            enabledPolicies = this._store.getPoliciesByResourceSignature(serviceName, policySignature, true);
            disabledPolicies = this._store.getPoliciesByResourceSignature(serviceName, policySignature, false);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving policies from service store!", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(enabledPolicies)) {
            ret = disabledPolicies;
        } else if (CollectionUtils.isEmpty(disabledPolicies)) {
            ret = enabledPolicies;
        } else {
            ret = enabledPolicies;
            ret.addAll(disabledPolicies);
        }
        if (LOG.isDebugEnabled()) {
            int count = ret == null ? 0 : ret.size();
            LOG.debug(String.format("<== RangerValidator.getPoliciesForResourceSignature(%s, %s): count[%d], %s", serviceName, policySignature, count, ret));
        }
        return ret;
    }

    RangerSecurityZone getSecurityZone(Long id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getSecurityZone(" + id + ")");
        }
        RangerSecurityZone result = null;
        if (id != null) {
            try {
                result = this._store.getSecurityZone(id);
            }
            catch (Exception e) {
                LOG.debug("Encountred exception while retrieving security zone from service store!", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getSecurityZone(" + id + "): " + result);
        }
        return result;
    }

    RangerSecurityZone getSecurityZone(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getSecurityZone(" + name + ")");
        }
        RangerSecurityZone result = null;
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            try {
                result = this._store.getSecurityZone(name);
            }
            catch (Exception e) {
                LOG.debug("Encountred exception while retrieving security zone from service store!", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getSecurityZone(" + name + "): " + result);
        }
        return result;
    }

    Set<String> getAccessTypes(RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getAccessTypes(" + serviceDef + ")");
        }
        HashSet<String> accessTypes = new HashSet<String>();
        if (serviceDef == null) {
            LOG.warn("serviceDef passed in was null!");
        } else if (CollectionUtils.isEmpty(serviceDef.getAccessTypes())) {
            LOG.warn("AccessTypeDef collection on serviceDef was null!");
        } else {
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : serviceDef.getAccessTypes()) {
                if (accessTypeDef == null) {
                    LOG.warn("Access type def was null!");
                    continue;
                }
                String accessType = accessTypeDef.getName();
                if (StringUtils.isBlank((CharSequence)accessType)) {
                    LOG.warn("Access type def name was null/empty/blank!");
                    continue;
                }
                accessTypes.add(accessType);
            }
            if (serviceDef.getMarkerAccessTypes() != null) {
                for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : serviceDef.getMarkerAccessTypes()) {
                    if (accessTypeDef == null) continue;
                    accessTypes.add(accessTypeDef.getName());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getAccessTypes(" + serviceDef + "): " + accessTypes);
        }
        return accessTypes;
    }

    boolean getIsAuditEnabled(RangerPolicy policy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getIsAuditEnabled(" + policy + ")");
        }
        boolean isEnabled = false;
        if (policy == null) {
            LOG.warn("policy was null!");
        } else {
            isEnabled = policy.getIsAuditEnabled() == null ? true : policy.getIsAuditEnabled();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getIsAuditEnabled(" + policy + "): " + isEnabled);
        }
        return isEnabled;
    }

    Set<String> getMandatoryResourceNames(RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getMandatoryResourceNames(" + serviceDef + ")");
        }
        HashSet<String> resourceNames = new HashSet<String>();
        if (serviceDef == null) {
            LOG.warn("serviceDef passed in was null!");
        } else if (CollectionUtils.isEmpty(serviceDef.getResources())) {
            LOG.warn("ResourceDef collection on serviceDef was null!");
        } else {
            for (RangerServiceDef.RangerResourceDef resourceTypeDef : serviceDef.getResources()) {
                if (resourceTypeDef == null) {
                    LOG.warn("resource type def was null!");
                    continue;
                }
                Boolean mandatory = resourceTypeDef.getMandatory();
                if (mandatory == null || !mandatory.booleanValue()) continue;
                String resourceName = resourceTypeDef.getName();
                if (StringUtils.isBlank((CharSequence)resourceName)) {
                    LOG.warn("Resource def name was null/empty/blank!");
                    continue;
                }
                resourceNames.add(resourceName.toLowerCase());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getMandatoryResourceNames(" + serviceDef + "): " + resourceNames);
        }
        return resourceNames;
    }

    Set<String> getAllResourceNames(RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getAllResourceNames(" + serviceDef + ")");
        }
        HashSet<String> resourceNames = new HashSet<String>();
        if (serviceDef == null) {
            LOG.warn("serviceDef passed in was null!");
        } else if (CollectionUtils.isEmpty(serviceDef.getResources())) {
            LOG.warn("ResourceDef collection on serviceDef was null!");
        } else {
            for (RangerServiceDef.RangerResourceDef resourceTypeDef : serviceDef.getResources()) {
                if (resourceTypeDef == null) {
                    LOG.warn("resource type def was null!");
                    continue;
                }
                String resourceName = resourceTypeDef.getName();
                if (StringUtils.isBlank((CharSequence)resourceName)) {
                    LOG.warn("Resource def name was null/empty/blank!");
                    continue;
                }
                resourceNames.add(resourceName.toLowerCase());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getAllResourceNames(" + serviceDef + "): " + resourceNames);
        }
        return resourceNames;
    }

    void convertPolicyResourceNamesToLower(Map<String, RangerPolicy.RangerPolicyResource> resources) {
        HashMap<String, RangerPolicy.RangerPolicyResource> lowerCasePolicyResources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        if (resources != null) {
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : resources.entrySet()) {
                String lowerCasekey = entry.getKey().toLowerCase();
                lowerCasePolicyResources.put(lowerCasekey, entry.getValue());
            }
            resources.clear();
            resources.putAll(lowerCasePolicyResources);
        }
    }

    Map<String, String> getValidationRegExes(RangerServiceDef serviceDef) {
        if (serviceDef == null || CollectionUtils.isEmpty(serviceDef.getResources())) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
            if (resourceDef == null) {
                LOG.warn("A resource def in resource def collection is null");
                continue;
            }
            String name = resourceDef.getName();
            String regEx = resourceDef.getValidationRegEx();
            if (StringUtils.isBlank((CharSequence)name)) {
                LOG.warn("resource name is null/empty/blank");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)regEx)) {
                LOG.debug("validation regex is null/empty/blank");
                continue;
            }
            result.put(name, regEx);
        }
        return result;
    }

    int getEnumDefaultIndex(RangerServiceDef.RangerEnumDef enumDef) {
        int index = enumDef == null ? -1 : (enumDef.getDefaultIndex() == null ? 0 : enumDef.getDefaultIndex());
        return index;
    }

    Collection<String> getImpliedGrants(RangerServiceDef.RangerAccessTypeDef def) {
        if (def == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(def.getImpliedGrants())) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(def.getImpliedGrants().size());
        for (String name : def.getImpliedGrants()) {
            if (StringUtils.isBlank((CharSequence)name)) {
                result.add(name);
                continue;
            }
            result.add(name.toLowerCase());
        }
        return result;
    }

    Map<String, RangerPolicy.RangerPolicyResource> getPolicyResourceWithLowerCaseKeys(Map<String, RangerPolicy.RangerPolicyResource> input) {
        if (input == null) {
            return null;
        }
        HashMap<String, RangerPolicy.RangerPolicyResource> output = new HashMap<String, RangerPolicy.RangerPolicyResource>(input.size());
        for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : input.entrySet()) {
            output.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return output;
    }

    boolean isUnique(Long value, Set<Long> alreadySeen, String valueName, String collectionName, List<ValidationFailureDetails> failures) {
        return this.isUnique(value, null, alreadySeen, valueName, collectionName, failures);
    }

    boolean isUnique(Long value, String valueContext, Set<Long> alreadySeen, String valueName, String collectionName, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s)", value, alreadySeen, valueName, collectionName, failures));
        }
        boolean valid = true;
        if (value == null) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).subField(valueContext).isMissing().becauseOf(String.format("%s[%s] is null/empty", valueName, value)).build());
            valid = false;
        } else if (alreadySeen.contains(value)) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).subField(value.toString()).isSemanticallyIncorrect().becauseOf(String.format("duplicate %s[%s] in %s", valueName, value, collectionName)).build());
            valid = false;
        } else {
            alreadySeen.add(value);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s): %s", value, alreadySeen, valueName, collectionName, failures, valid));
        }
        return valid;
    }

    boolean isUnique(Integer value, Set<Integer> alreadySeen, String valueName, String collectionName, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s)", value, alreadySeen, valueName, collectionName, failures));
        }
        boolean valid = true;
        if (value == null) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).isMissing().becauseOf(String.format("%s[%s] is null/empty", valueName, value)).build());
            valid = false;
        } else if (alreadySeen.contains(value)) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).subField(value.toString()).isSemanticallyIncorrect().becauseOf(String.format("duplicate %s[%s] in %s", valueName, value, collectionName)).build());
            valid = false;
        } else {
            alreadySeen.add(value);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s): %s", value, alreadySeen, valueName, collectionName, failures, valid));
        }
        return valid;
    }

    boolean isValidResourceName(String value, String valueContext, List<ValidationFailureDetails> failures) {
        boolean ret = true;
        if (value != null && !StringUtils.isEmpty((CharSequence)value)) {
            int sz = value.length();
            for (int i = 0; i < sz; ++i) {
                char c = value.charAt(i);
                if (Character.isLowerCase(c) || c == '-' || c == '_') continue;
                ret = false;
                break;
            }
        } else {
            ret = false;
        }
        if (!ret) {
            ValidationErrorCode errorCode = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_NOT_LOWERCASE_NAME;
            failures.add(new ValidationFailureDetailsBuilder().errorCode(errorCode.getErrorCode()).field(value).becauseOf(errorCode.getMessage(valueContext, value)).build());
        }
        return ret;
    }

    boolean isUnique(String value, Set<String> alreadySeen, String valueName, String collectionName, List<ValidationFailureDetails> failures) {
        return this.isUnique(value, null, alreadySeen, valueName, collectionName, failures);
    }

    boolean isUnique(String value, String valueContext, Set<String> alreadySeen, String valueName, String collectionName, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s)", value, alreadySeen, valueName, collectionName, failures));
        }
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)value)) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).subField(valueContext).isMissing().becauseOf(String.format("%s[%s] is null/empty", valueName, value)).build());
            valid = false;
        } else if (alreadySeen.contains(value.toLowerCase())) {
            failures.add(new ValidationFailureDetailsBuilder().field(valueName).subField(value).isSemanticallyIncorrect().becauseOf(String.format("duplicate %s[%s] in %s", valueName, value, collectionName)).build());
            valid = false;
        } else {
            alreadySeen.add(value.toLowerCase());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefValidator.isValueUnique(%s, %s, %s, %s, %s): %s", value, alreadySeen, valueName, collectionName, failures, valid));
        }
        return valid;
    }

    Map<String, RangerServiceDef.RangerEnumDef> getEnumDefMap(List<RangerServiceDef.RangerEnumDef> enumDefs) {
        HashMap<String, RangerServiceDef.RangerEnumDef> result = new HashMap<String, RangerServiceDef.RangerEnumDef>();
        if (enumDefs != null) {
            for (RangerServiceDef.RangerEnumDef enumDef : enumDefs) {
                result.put(enumDef.getName(), enumDef);
            }
        }
        return result;
    }

    Set<String> getEnumValues(RangerServiceDef.RangerEnumDef enumDef) {
        HashSet<String> result = new HashSet<String>();
        if (enumDef != null) {
            for (RangerServiceDef.RangerEnumElementDef element : enumDef.getElements()) {
                result.add(element.getName());
            }
        }
        return result;
    }

    static Map<Integer, Integer> createMap(int[][] data) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (data != null) {
            for (int[] row : data) {
                Integer key = row[0];
                Integer value = row[1];
                if (result.containsKey(key)) {
                    LOG.warn("createMap: Internal error: duplicate key: multiple rows found for [" + key + "]. Skipped");
                    continue;
                }
                result.put(key, value);
            }
        }
        return result;
    }

    static Map<Integer, String> createMap(Object[][] data) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        if (data != null) {
            for (Object[] row : data) {
                Integer key = (Integer)row[0];
                String value = (String)row[1];
                if (key == null) {
                    LOG.warn("createMap: error converting key[" + row[0] + "] to Integer! Sipped!");
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)value)) {
                    LOG.warn("createMap: empty/null value.  Skipped!");
                    continue;
                }
                if (result.containsKey(key)) {
                    LOG.warn("createMap: Internal error: duplicate key.  Multiple rows found for [" + key + "]. Skipped");
                    continue;
                }
                result.put(key, value);
            }
        }
        return result;
    }

    RangerRole getRangerRole(Long id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidator.getRangerRole(" + id + ")");
        }
        RangerRole result = null;
        try {
            result = this._roleStore.getRole(id);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving RangerRole from RoleStore store!", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidator.getRangerRole(" + id + "): " + result);
        }
        return result;
    }

    boolean roleExists(Long id) {
        try {
            return this._roleStore.roleExists(id);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving RangerRole from role store!", (Throwable)e);
            return false;
        }
    }

    boolean roleExists(String name) {
        try {
            return this._roleStore.roleExists(name);
        }
        catch (Exception e) {
            LOG.debug("Encountred exception while retrieving RangerRole from role store!", (Throwable)e);
            return false;
        }
    }

    public static enum Action {
        CREATE,
        UPDATE,
        DELETE;

    }
}

