/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerAccessContext {
    public static final String CONTEXT_INFO_CLIENT_TYPE = "clientType";
    public static final String CONTEXT_INFO_CLUSTER_NAME = "clusterName";
    public static final String CONTEXT_INFO_CLUSTER_TYPE = "clusterType";
    public static final String CONTEXT_INFO_REQUEST_DATA = "requestData";
    private String serviceType;
    private String serviceName;
    private long accessTime;
    private String clientIpAddress;
    private List<String> forwardedIpAddresses;
    private Map<String, Object> additionalInfo;

    public RangerAccessContext() {
        this(null, null, 0L, null, null, null);
    }

    public RangerAccessContext(String serviceType, String serviceName) {
        this(serviceType, serviceName, 0L, null, null, null);
    }

    public RangerAccessContext(String serviceType, String serviceName, long accessTime, String clientIpAddress, List<String> forwardedIpAddresses, Map<String, Object> additionalInfo) {
        this.serviceType = serviceType;
        this.serviceName = serviceName;
        this.accessTime = accessTime <= 0L ? System.currentTimeMillis() : accessTime;
        this.clientIpAddress = clientIpAddress;
        this.forwardedIpAddresses = forwardedIpAddresses;
        this.additionalInfo = additionalInfo;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public void setClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
    }

    public List<String> getForwardedIpAddresses() {
        return this.forwardedIpAddresses;
    }

    public void setForwardedIpAddresses(List<String> forwardedIpAddresses) {
        this.forwardedIpAddresses = forwardedIpAddresses;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public int hashCode() {
        return Objects.hash(this.serviceType, this.serviceName, this.accessTime, this.clientIpAddress, this.forwardedIpAddresses, this.additionalInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangerAccessContext that = (RangerAccessContext)o;
        return Objects.equals(this.serviceType, that.serviceType) && Objects.equals(this.serviceName, that.serviceName) && this.accessTime == that.accessTime && Objects.equals(this.clientIpAddress, that.clientIpAddress) && Objects.equals(this.forwardedIpAddresses, that.forwardedIpAddresses) && Objects.equals(this.additionalInfo, that.additionalInfo);
    }

    public String toString() {
        return "RangerAccessContext{serviceType=" + this.serviceType + ", serviceName=" + this.serviceName + ", accessTime=" + this.accessTime + ", clientIpAddress='" + this.clientIpAddress + '\'' + ", forwardedIpAddresses=" + this.forwardedIpAddresses + ", additionalInfo=" + this.additionalInfo + '}';
    }
}

