/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.lmq;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class LMQPushConsumer {
    public static final String CLUSTER_NAME = "DefaultCluster";
    public static final String BROKER_NAME = "broker-a";
    public static final String TOPIC = "TopicLMQParent";
    public static final String LMQ_TOPIC = "%LMQ%123";
    public static final String CONSUMER_GROUP = "CID_LMQ_1";
    public static final String NAMESRV_ADDR = "127.0.0.1:9876";
    public static final HashMap<Long, String> BROKER_ADDR_MAP = new HashMap<Long, String>(){
        {
            this.put(0L, "127.0.0.1:10911");
        }
    };

    public static void main(String[] args) throws InterruptedException, MQClientException {
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(CONSUMER_GROUP);
        consumer.setNamesrvAddr(NAMESRV_ADDR);
        consumer.subscribe(LMQ_TOPIC, "*");
        consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        consumer.registerMessageListener(new MessageListenerConcurrently(){

            public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                System.out.printf("%s Receive New Messages: %s %n", Thread.currentThread().getName(), msgs);
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
        });
        consumer.start();
        consumer.getDefaultMQPushConsumerImpl().getmQClientFactory().updateTopicRouteInfoFromNameServer(TOPIC);
        TopicRouteData topicRouteData = new TopicRouteData();
        BrokerData brokerData = new BrokerData();
        brokerData.setCluster(CLUSTER_NAME);
        brokerData.setBrokerName(BROKER_NAME);
        brokerData.setBrokerAddrs(BROKER_ADDR_MAP);
        topicRouteData.setBrokerDatas((List)Lists.newArrayList((Object[])new BrokerData[]{brokerData}));
        consumer.getDefaultMQPushConsumerImpl().getmQClientFactory().getTopicRouteTable().put(LMQ_TOPIC, topicRouteData);
        consumer.getDefaultMQPushConsumerImpl().updateTopicSubscribeInfo(LMQ_TOPIC, new HashSet<MessageQueue>(Arrays.asList(new MessageQueue(LMQ_TOPIC, BROKER_NAME, 0))));
        consumer.getDefaultMQPushConsumerImpl().getmQClientFactory().doRebalance();
        System.out.printf("Consumer Started.%n", new Object[0]);
    }
}

