/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.timer;

import java.nio.ByteBuffer;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.RunningFlags;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.logfile.MappedFile;

public class TimerLog {
    private static Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    public static final int BLANK_MAGIC_CODE = -875286124;
    private static final int MIN_BLANK_LEN = 16;
    public static final int UNIT_SIZE = 52;
    public static final int UNIT_PRE_SIZE_FOR_MSG = 28;
    public static final int UNIT_PRE_SIZE_FOR_METRIC = 40;
    private final MappedFileQueue mappedFileQueue;
    private final int fileSize;

    public TimerLog(String storePath, int fileSize) {
        this(storePath, fileSize, null, false);
    }

    public TimerLog(String storePath, int fileSize, RunningFlags runningFlags, boolean writeWithoutMmap) {
        this.fileSize = fileSize;
        this.mappedFileQueue = new MappedFileQueue(storePath, fileSize, null, runningFlags, writeWithoutMmap);
    }

    public boolean load() {
        return this.mappedFileQueue.load();
    }

    public long append(byte[] data) {
        return this.append(data, 0, data.length);
    }

    public long append(byte[] data, int pos, int len) {
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        if (null == mappedFile || mappedFile.isFull()) {
            mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
        }
        if (null == mappedFile) {
            log.error("Create mapped file1 error for timer log");
            return -1L;
        }
        if (len + 16 > mappedFile.getFileSize() - mappedFile.getWrotePosition()) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(16);
            byteBuffer.putInt(mappedFile.getFileSize() - mappedFile.getWrotePosition());
            byteBuffer.putLong(0L);
            byteBuffer.putInt(-875286124);
            if (!mappedFile.appendMessage(byteBuffer.array())) {
                log.error("Append blank error for timer log");
                return -1L;
            }
            mappedFile.setWrotePosition(mappedFile.getFileSize());
            mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
            if (null == mappedFile) {
                log.error("create mapped file2 error for timer log");
                return -1L;
            }
        }
        long currPosition = mappedFile.getFileFromOffset() + (long)mappedFile.getWrotePosition();
        if (!mappedFile.appendMessage(data, pos, len)) {
            log.error("Append error for timer log");
            return -1L;
        }
        return currPosition;
    }

    public SelectMappedBufferResult getTimerMessage(long offsetPy) {
        MappedFile mappedFile = this.mappedFileQueue.findMappedFileByOffset(offsetPy);
        if (null == mappedFile) {
            return null;
        }
        return mappedFile.selectMappedBuffer((int)(offsetPy % (long)mappedFile.getFileSize()));
    }

    public SelectMappedBufferResult getWholeBuffer(long offsetPy) {
        MappedFile mappedFile = this.mappedFileQueue.findMappedFileByOffset(offsetPy);
        if (null == mappedFile) {
            return null;
        }
        return mappedFile.selectMappedBuffer(0);
    }

    public MappedFileQueue getMappedFileQueue() {
        return this.mappedFileQueue;
    }

    public void shutdown() {
        try {
            this.mappedFileQueue.flush(0);
        }
        catch (Throwable e) {
            log.error("flush error when shutdown", e);
        }
        this.mappedFileQueue.cleanResourcesAll();
    }

    public int getOffsetForLastUnit() {
        return this.fileSize - (this.fileSize - 16) % 52 - 16 - 52;
    }
}

