/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv.route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class ZoneRouteRPCHook
implements RPCHook {
    public void doBeforeRequest(String remoteAddr, RemotingCommand request) {
    }

    public void doAfterResponse(String remoteAddr, RemotingCommand request, RemotingCommand response) {
        if (105 != request.getCode()) {
            return;
        }
        if (response == null || response.getBody() == null || 0 != response.getCode()) {
            return;
        }
        boolean zoneMode = Boolean.parseBoolean((String)request.getExtFields().get("__ZONE_MODE"));
        if (!zoneMode) {
            return;
        }
        String zoneName = (String)request.getExtFields().get("__ZONE_NAME");
        if (StringUtils.isBlank((CharSequence)zoneName)) {
            return;
        }
        TopicRouteData topicRouteData = (TopicRouteData)RemotingSerializable.decode((byte[])response.getBody(), TopicRouteData.class);
        response.setBody(this.filterByZoneName(topicRouteData, zoneName).encode());
    }

    private TopicRouteData filterByZoneName(TopicRouteData topicRouteData, String zoneName) {
        ArrayList<BrokerData> brokerDataReserved = new ArrayList<BrokerData>();
        HashMap<String, BrokerData> brokerDataRemoved = new HashMap<String, BrokerData>();
        for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
            if (brokerData.getBrokerAddrs() == null) continue;
            if (brokerData.getBrokerAddrs().get(0L) == null || StringUtils.equalsIgnoreCase((CharSequence)brokerData.getZoneName(), (CharSequence)zoneName)) {
                brokerDataReserved.add(brokerData);
                continue;
            }
            brokerDataRemoved.put(brokerData.getBrokerName(), brokerData);
        }
        topicRouteData.setBrokerDatas(brokerDataReserved);
        ArrayList<QueueData> queueDataReserved = new ArrayList<QueueData>();
        for (QueueData queueData : topicRouteData.getQueueDatas()) {
            if (brokerDataRemoved.containsKey(queueData.getBrokerName())) continue;
            queueDataReserved.add(queueData);
        }
        topicRouteData.setQueueDatas(queueDataReserved);
        if (topicRouteData.getFilterServerTable() != null && !topicRouteData.getFilterServerTable().isEmpty()) {
            for (Map.Entry entry : brokerDataRemoved.entrySet()) {
                BrokerData brokerData = (BrokerData)entry.getValue();
                brokerData.getBrokerAddrs().values().forEach(brokerAddr -> {
                    List cfr_ignored_0 = (List)topicRouteData.getFilterServerTable().remove(brokerAddr);
                });
            }
        }
        return topicRouteData;
    }
}

