/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.queue;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.common.queue.RoundQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class ConcurrentTreeMap<K, V> {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final ReentrantLock lock;
    private TreeMap<K, V> tree;
    private RoundQueue<K> roundQueue;

    public ConcurrentTreeMap(int capacity, Comparator<? super K> comparator) {
        this.tree = new TreeMap(comparator);
        this.roundQueue = new RoundQueue(capacity);
        this.lock = new ReentrantLock(true);
    }

    public Map.Entry<K, V> pollFirstEntry() {
        this.lock.lock();
        try {
            Map.Entry<K, V> entry = this.tree.pollFirstEntry();
            return entry;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsentAndRetExsit(K key, V value) {
        this.lock.lock();
        try {
            V exist;
            if (this.roundQueue.put(key)) {
                V exist2 = this.tree.get(key);
                if (null == exist2) {
                    this.tree.put(key, value);
                    exist2 = value;
                }
                log.warn("putIfAbsentAndRetExsit success. " + key);
                V v = exist2;
                return v;
            }
            V v = exist = this.tree.get(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }
}

