/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha;

import java.net.InetSocketAddress;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.ha.HAConnection;
import org.apache.rocketmq.store.ha.HAConnectionState;
import org.apache.rocketmq.store.ha.HAConnectionStateNotificationRequest;
import org.apache.rocketmq.store.ha.HAService;

public class HAConnectionStateNotificationService
extends ServiceThread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final long CONNECTION_ESTABLISH_TIMEOUT = 10000L;
    private volatile HAConnectionStateNotificationRequest request;
    private volatile long lastCheckTimeStamp = -1L;
    private HAService haService;
    private DefaultMessageStore defaultMessageStore;

    public HAConnectionStateNotificationService(HAService haService, DefaultMessageStore defaultMessageStore) {
        this.haService = haService;
        this.defaultMessageStore = defaultMessageStore;
    }

    public String getServiceName() {
        if (this.defaultMessageStore != null && this.defaultMessageStore.getBrokerConfig().isInBrokerContainer()) {
            return this.defaultMessageStore.getBrokerIdentity().getIdentifier() + HAConnectionStateNotificationService.class.getSimpleName();
        }
        return HAConnectionStateNotificationService.class.getSimpleName();
    }

    public synchronized void setRequest(HAConnectionStateNotificationRequest request) {
        if (this.request != null) {
            this.request.getRequestFuture().cancel(true);
        }
        this.request = request;
        this.lastCheckTimeStamp = System.currentTimeMillis();
    }

    private synchronized void doWaitConnectionState() {
        if (this.request == null || this.request.getRequestFuture().isDone()) {
            return;
        }
        if (this.defaultMessageStore.getMessageStoreConfig().getBrokerRole() == BrokerRole.SLAVE) {
            if (this.haService.getHAClient().getCurrentState() == this.request.getExpectState()) {
                this.request.getRequestFuture().complete(true);
                this.request = null;
            } else if (this.haService.getHAClient().getCurrentState() == HAConnectionState.READY) {
                if (System.currentTimeMillis() - this.lastCheckTimeStamp > 10000L) {
                    LOGGER.error("Wait HA connection establish with {} timeout", (Object)this.request.getRemoteAddr());
                    this.request.getRequestFuture().complete(false);
                    this.request = null;
                }
            } else {
                this.lastCheckTimeStamp = System.currentTimeMillis();
            }
        } else {
            boolean connectionFound = false;
            for (HAConnection connection : this.haService.getConnectionList()) {
                if (!this.checkConnectionStateAndNotify(connection)) continue;
                connectionFound = true;
            }
            if (connectionFound) {
                this.lastCheckTimeStamp = System.currentTimeMillis();
            }
            if (!connectionFound && System.currentTimeMillis() - this.lastCheckTimeStamp > 10000L) {
                LOGGER.error("Wait HA connection establish with {} timeout", (Object)this.request.getRemoteAddr());
                this.request.getRequestFuture().complete(false);
                this.request = null;
            }
        }
    }

    public synchronized boolean checkConnectionStateAndNotify(HAConnection connection) {
        if (this.request == null || connection == null) {
            return false;
        }
        try {
            String remoteAddress = ((InetSocketAddress)connection.getSocketChannel().getRemoteAddress()).getAddress().getHostAddress();
            if (remoteAddress.equals(this.request.getRemoteAddr())) {
                HAConnectionState connState = connection.getCurrentState();
                if (connState == this.request.getExpectState()) {
                    this.request.getRequestFuture().complete(true);
                    this.request = null;
                } else if (this.request.isNotifyWhenShutdown() && connState == HAConnectionState.SHUTDOWN) {
                    this.request.getRequestFuture().complete(false);
                    this.request = null;
                }
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Check connection address exception: {}", (Throwable)e);
        }
        return false;
    }

    public void run() {
        LOGGER.info(this.getServiceName() + " service started");
        while (!this.isStopped()) {
            try {
                this.waitForRunning(1000L);
                this.doWaitConnectionState();
            }
            catch (Exception e) {
                LOGGER.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
            }
        }
        LOGGER.info(this.getServiceName() + " service end");
    }
}

