/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueStore;
import org.rocksdb.RocksDBException;

public class RocksGroupCommitService
extends ServiceThread {
    private static final int MAX_BUFFER_SIZE = 100000;
    private static final int PREFERRED_DISPATCH_REQUEST_COUNT = 256;
    private final LinkedBlockingQueue<DispatchRequest> buffer;
    private final RocksDBConsumeQueueStore store;
    private final List<DispatchRequest> requests = new ArrayList<DispatchRequest>(256);

    public RocksGroupCommitService(RocksDBConsumeQueueStore store) {
        this.store = store;
        this.buffer = new LinkedBlockingQueue(100000);
    }

    public String getServiceName() {
        return "RocksGroupCommit";
    }

    public void run() {
        log.info("{} service started", (Object)this.getServiceName());
        while (!this.isStopped()) {
            try {
                this.waitForRunning(10L);
                this.doCommit();
            }
            catch (Exception e) {
                log.warn("{} service has exception. ", (Object)this.getServiceName(), (Object)e);
            }
        }
        log.info("{} service end", (Object)this.getServiceName());
    }

    public void putRequest(DispatchRequest request) throws InterruptedException {
        while (!this.buffer.offer(request, 3L, TimeUnit.SECONDS)) {
            log.warn("RocksGroupCommitService#buffer is full, 3s elapsed before space becomes available");
        }
        this.wakeup();
    }

    private void doCommit() {
        block0: while (!this.buffer.isEmpty()) {
            while (true) {
                DispatchRequest dispatchRequest;
                if (null != (dispatchRequest = this.buffer.poll())) {
                    this.requests.add(dispatchRequest);
                }
                if (this.requests.isEmpty()) continue block0;
                if (null != dispatchRequest && this.requests.size() < 256) continue;
                this.groupCommit();
            }
        }
    }

    private void groupCommit() {
        while (!this.store.isStopped()) {
            try {
                this.store.putMessagePosition(this.requests);
                break;
            }
            catch (RocksDBException e) {
                log.error("Failed to build consume queue in RocksDB", (Throwable)e);
            }
        }
    }
}

