/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig.multicast;

import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import org.apache.servicecomb.registry.lightweight.MessageType;
import org.apache.servicecomb.registry.lightweight.RegisterInstanceEvent;
import org.apache.servicecomb.zeroconfig.AbstractZeroConfigRegistration;
import org.apache.servicecomb.zeroconfig.multicast.Multicast;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MulticastRegistration
extends AbstractZeroConfigRegistration
implements InitializingBean {
    private static final String NAME = "zero-config-multicast";
    protected Multicast multicast;

    @Autowired
    public MulticastRegistration setMulticast(Multicast multicast) {
        this.multicast = multicast;
        return this;
    }

    public String name() {
        return NAME;
    }

    @Override
    public boolean enabled() {
        return this.config.isMulticast();
    }

    public void afterPropertiesSet() {
        this.eventBus.register((Object)this);
    }

    protected void doSendRegister() throws IOException {
        this.multicast.send(MessageType.REGISTER, this.self.buildRegisterRequest());
    }

    protected void doSendUnregister() throws IOException {
        this.multicast.send(MessageType.UNREGISTER, this.self.buildUnregisterRequest());
    }

    @Subscribe
    public void onRegisterInstance(RegisterInstanceEvent event) {
        if (event.getInstance().getInstanceId().equals(this.self.getInstance().getInstanceId())) {
            return;
        }
        this.sendRegister();
    }
}

