/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.with;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.SegmentType;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.expression.type.ColumnSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SubqueryTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.util.SubqueryTableBindUtils;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.DifferenceInColumnCountOfSelectListAndColumnNameListException;
import org.apache.shardingsphere.infra.exception.kernel.syntax.DuplicateCommonTableExpressionAliasException;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TableSourceType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class CommonTableExpressionSegmentBinder {
    public static CommonTableExpressionSegment bind(CommonTableExpressionSegment segment, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> externalTableBinderContexts, boolean recursive) {
        if (segment.getAliasName().isPresent()) {
            ShardingSpherePreconditions.checkState((!binderContext.getCommonTableExpressionsSegmentsUniqueAliases().contains(segment.getAliasName().get()) ? 1 : 0) != 0, () -> new DuplicateCommonTableExpressionAliasException((String)segment.getAliasName().get()));
            binderContext.getCommonTableExpressionsSegmentsUniqueAliases().add((String)segment.getAliasName().get());
        }
        if (recursive && segment.getAliasName().isPresent()) {
            binderContext.getExternalTableBinderContexts().put((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)((String)segment.getAliasName().get())), (Object)new SimpleTableSegmentBinderContext(segment.getColumns().stream().map(ColumnProjectionSegment::new).collect(Collectors.toList()), TableSourceType.TEMPORARY_TABLE));
        }
        SubqueryTableSegment subqueryTableSegment = new SubqueryTableSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getSubquery());
        segment.getAliasSegment().ifPresent(arg_0 -> ((SubqueryTableSegment)subqueryTableSegment).setAlias(arg_0));
        SubqueryTableSegment boundSubquerySegment = SubqueryTableSegmentBinder.bind(subqueryTableSegment, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)LinkedHashMultimap.create(), binderContext.getExternalTableBinderContexts(), true);
        CommonTableExpressionSegment result = new CommonTableExpressionSegment(segment.getStartIndex(), segment.getStopIndex(), (AliasSegment)boundSubquerySegment.getAliasSegment().orElse(null), boundSubquerySegment.getSubquery());
        Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> currentTableBinderContexts = CommonTableExpressionSegmentBinder.createCurrentTableBinderContexts(segment.getColumns(), binderContext, boundSubquerySegment.getSubquery().getSelect());
        segment.getColumns().forEach(each -> result.getColumns().add(ColumnSegmentBinder.bind(each, SegmentType.DEFINITION_COLUMNS, binderContext, currentTableBinderContexts, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)LinkedHashMultimap.create())));
        CommonTableExpressionSegmentBinder.putExternalTableBinderContext(segment, externalTableBinderContexts, recursive, currentTableBinderContexts);
        return result;
    }

    private static Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> createCurrentTableBinderContexts(Collection<ColumnSegment> definitionColumns, SQLStatementBinderContext binderContext, SelectStatement selectStatement) {
        LinkedList<ProjectionSegment> subqueryProjections = SubqueryTableBindUtils.createSubqueryProjections(selectStatement.getProjections().getProjections(), new IdentifierValue(""), binderContext.getSqlStatement().getDatabaseType(), TableSourceType.TEMPORARY_TABLE);
        LinkedHashMultimap result = LinkedHashMultimap.create();
        Collection<ProjectionSegment> boundDefinitionColumns = CommonTableExpressionSegmentBinder.createBoundDefinitionColumns(definitionColumns, subqueryProjections);
        LinkedList<ProjectionSegment> boundProjectionSegments = definitionColumns.isEmpty() ? subqueryProjections : new LinkedList<ProjectionSegment>(boundDefinitionColumns);
        SimpleTableSegmentBinderContext tableSegmentBinderContext = new SimpleTableSegmentBinderContext(boundProjectionSegments, TableSourceType.TEMPORARY_TABLE);
        tableSegmentBinderContext.setFromWithSegment(true);
        result.put((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)""), (Object)tableSegmentBinderContext);
        return result;
    }

    private static Collection<ProjectionSegment> createBoundDefinitionColumns(Collection<ColumnSegment> definitionColumns, Collection<ProjectionSegment> projectionSegments) {
        LinkedList<ProjectionSegment> result = new LinkedList<ProjectionSegment>();
        Collection<ColumnSegment> boundDefinitionColumns = CommonTableExpressionSegmentBinder.bindDefinitionColumns(definitionColumns, new ArrayList<ProjectionSegment>(projectionSegments));
        boundDefinitionColumns.forEach(each -> result.add((ProjectionSegment)new ColumnProjectionSegment(each)));
        return result;
    }

    private static Collection<ColumnSegment> bindDefinitionColumns(Collection<ColumnSegment> definitionColumns, List<ProjectionSegment> projectionSegments) {
        ShardingSpherePreconditions.checkState((definitionColumns.isEmpty() || definitionColumns.size() == projectionSegments.size() ? 1 : 0) != 0, DifferenceInColumnCountOfSelectListAndColumnNameListException::new);
        int index = 0;
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (ColumnSegment each : definitionColumns) {
            ColumnSegment boundColumnSegment = CommonTableExpressionSegmentBinder.copy(each);
            ProjectionSegment projectionSegment = projectionSegments.get(index);
            if (projectionSegment instanceof ColumnProjectionSegment) {
                boundColumnSegment.setColumnBoundInfo(ColumnSegmentBinder.createColumnSegmentBoundInfo(each, ((ColumnProjectionSegment)projectionSegment).getColumn(), TableSourceType.TEMPORARY_TABLE));
            }
            result.add(boundColumnSegment);
            ++index;
        }
        return result;
    }

    private static ColumnSegment copy(ColumnSegment segment) {
        ColumnSegment result = new ColumnSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getIdentifier());
        result.setNestedObjectAttributes(segment.getNestedObjectAttributes());
        segment.getOwner().ifPresent(arg_0 -> ((ColumnSegment)result).setOwner(arg_0));
        result.setVariable(segment.isVariable());
        segment.getLeftParentheses().ifPresent(arg_0 -> ((ColumnSegment)result).setLeftParentheses(arg_0));
        segment.getRightParentheses().ifPresent(arg_0 -> ((ColumnSegment)result).setRightParentheses(arg_0));
        return result;
    }

    private static void putExternalTableBinderContext(CommonTableExpressionSegment segment, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> externalTableBinderContexts, boolean recursive, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> currentTableBinderContexts) {
        if (!segment.getAliasName().isPresent()) {
            return;
        }
        if (recursive && segment.getAliasName().isPresent()) {
            externalTableBinderContexts.removeAll((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)((String)segment.getAliasName().get())));
        }
        externalTableBinderContexts.putAll((Object)CaseInsensitiveMap.CaseInsensitiveString.of((String)((String)segment.getAliasName().get())), (Iterable)currentTableBinderContexts.values());
    }

    @Generated
    private CommonTableExpressionSegmentBinder() {
    }
}

