/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.dal;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.FlushStatement;

public final class FlushStatementBinder
implements SQLStatementBinder<FlushStatement> {
    @Override
    public FlushStatement bind(FlushStatement sqlStatement, SQLStatementBinderContext binderContext) {
        Collection tables = sqlStatement.getTables();
        if (tables.isEmpty()) {
            return sqlStatement;
        }
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        ArrayList<SimpleTableSegment> boundTables = new ArrayList<SimpleTableSegment>();
        for (SimpleTableSegment each : tables) {
            boundTables.add(SimpleTableSegmentBinder.bind(each, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts));
        }
        return this.copyFlushStatement(sqlStatement, boundTables);
    }

    private FlushStatement copyFlushStatement(FlushStatement sqlStatement, Collection<SimpleTableSegment> tables) {
        if (tables.equals(sqlStatement.getTables())) {
            return sqlStatement;
        }
        try {
            FlushStatement result = (FlushStatement)sqlStatement.getClass().getDeclaredConstructor(DatabaseType.class, Collection.class, Boolean.TYPE).newInstance(sqlStatement.getDatabaseType(), tables, sqlStatement.isFlushTable());
            SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
            return result;
        }
        catch (ReflectiveOperationException ex) {
            return sqlStatement;
        }
    }
}

