/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.dcl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.GrantStatement;

public final class GrantStatementBinder
implements SQLStatementBinder<GrantStatement> {
    @Override
    public GrantStatement bind(GrantStatement sqlStatement, SQLStatementBinderContext binderContext) {
        Collection tables = sqlStatement.getTables();
        if (tables.isEmpty()) {
            return sqlStatement;
        }
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        ArrayList<SimpleTableSegment> boundTables = new ArrayList<SimpleTableSegment>();
        for (SimpleTableSegment each : tables) {
            boundTables.add(SimpleTableSegmentBinder.bind(each, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts));
        }
        return this.copyGrantStatement(sqlStatement, boundTables);
    }

    private GrantStatement copyGrantStatement(GrantStatement sqlStatement, Collection<SimpleTableSegment> tables) {
        if (tables.equals(sqlStatement.getTables())) {
            return sqlStatement;
        }
        GrantStatement result = new GrantStatement(sqlStatement.getDatabaseType());
        result.getTables().addAll(tables);
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }
}

