/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.engine.segment.SegmentType;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.expression.type.ColumnSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;

public final class CreateIndexStatementBinder
implements SQLStatementBinder<CreateIndexStatement> {
    @Override
    public CreateIndexStatement bind(CreateIndexStatement sqlStatement, SQLStatementBinderContext binderContext) {
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        SimpleTableSegment boundTable = SimpleTableSegmentBinder.bind(sqlStatement.getTable(), binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts);
        Collection boundColumns = sqlStatement.getColumns().stream().map(arg_0 -> CreateIndexStatementBinder.lambda$bind$0(binderContext, (Multimap)tableBinderContexts, arg_0)).collect(Collectors.toList());
        return this.copy(sqlStatement, boundTable, boundColumns);
    }

    private CreateIndexStatement copy(CreateIndexStatement sqlStatement, SimpleTableSegment boundTable, Collection<ColumnSegment> boundColumns) {
        CreateIndexStatement result = new CreateIndexStatement(sqlStatement.getDatabaseType());
        result.setTable(boundTable);
        result.getColumns().addAll(boundColumns);
        result.setIndex(sqlStatement.getIndex());
        sqlStatement.getAnonymousIndexStartIndex().ifPresent(arg_0 -> ((CreateIndexStatement)result).setAnonymousIndexStartIndex(arg_0));
        result.setIfNotExists(sqlStatement.isIfNotExists());
        sqlStatement.getAlgorithmType().ifPresent(arg_0 -> ((CreateIndexStatement)result).setAlgorithmType(arg_0));
        sqlStatement.getLockTable().ifPresent(arg_0 -> ((CreateIndexStatement)result).setLockTable(arg_0));
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }

    private static /* synthetic */ ColumnSegment lambda$bind$0(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, ColumnSegment each) {
        return ColumnSegmentBinder.bind(each, SegmentType.DEFINITION_COLUMNS, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)LinkedHashMultimap.create());
    }
}

