/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.facade;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.driver.executor.callback.add.StatementAddCallback;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteCallback;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteUpdateCallback;
import org.apache.shardingsphere.driver.executor.callback.replay.StatementReplayCallback;
import org.apache.shardingsphere.driver.executor.engine.DriverExecuteExecutor;
import org.apache.shardingsphere.driver.executor.engine.DriverExecuteQueryExecutor;
import org.apache.shardingsphere.driver.executor.engine.DriverExecuteUpdateExecutor;
import org.apache.shardingsphere.driver.executor.engine.transaction.DriverTransactionSQLStatementExecutor;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.statement.StatementManager;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.executor.audit.SQLAuditEngine;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sqlfederation.engine.SQLFederationEngine;

public final class DriverExecutorFacade
implements AutoCloseable {
    private final ShardingSphereConnection connection;
    private final StatementOption statementOption;
    private final StatementManager statementManager;
    private final JDBCDriverType jdbcDriverType;
    private final SQLFederationEngine sqlFederationEngine;
    private final DriverExecuteQueryExecutor queryExecutor;
    private final DriverExecuteUpdateExecutor updateExecutor;
    private final DriverExecuteExecutor executeExecutor;

    public DriverExecutorFacade(ShardingSphereConnection connection, StatementOption statementOption, StatementManager statementManager, JDBCDriverType jdbcDriverType, ShardingSphereDatabase currentDatabase) {
        this.connection = connection;
        this.statementOption = statementOption;
        this.statementManager = statementManager;
        this.jdbcDriverType = jdbcDriverType;
        JDBCExecutor jdbcExecutor = new JDBCExecutor(connection.getContextManager().getExecutorEngine(), connection.getDatabaseConnectionManager().getConnectionContext());
        ShardingSphereMetaData metaData = connection.getContextManager().getMetaDataContexts().getMetaData();
        String currentSchemaName = new DatabaseTypeRegistry(currentDatabase.getProtocolType()).getDefaultSchemaName(connection.getCurrentDatabaseName());
        this.sqlFederationEngine = new SQLFederationEngine(connection.getCurrentDatabaseName(), currentSchemaName, metaData, connection.getContextManager().getMetaDataContexts().getStatistics(), jdbcExecutor);
        RawExecutor rawExecutor = new RawExecutor(connection.getContextManager().getExecutorEngine(), connection.getDatabaseConnectionManager().getConnectionContext());
        this.queryExecutor = new DriverExecuteQueryExecutor(connection, metaData, jdbcExecutor, rawExecutor, this.sqlFederationEngine);
        this.updateExecutor = new DriverExecuteUpdateExecutor(connection, metaData, jdbcExecutor, rawExecutor);
        this.executeExecutor = new DriverExecuteExecutor(connection, metaData, jdbcExecutor, rawExecutor, this.sqlFederationEngine, new DriverTransactionSQLStatementExecutor(connection));
    }

    public ResultSet executeQuery(ShardingSphereDatabase database, ShardingSphereMetaData metaData, QueryContext queryContext, Statement statement, Map<String, Integer> columnLabelAndIndexMap, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        SQLAuditEngine.audit((QueryContext)queryContext, (ShardingSphereDatabase)database);
        return this.queryExecutor.executeQuery(database, queryContext, this.createDriverExecutionPrepareEngine(database, metaData, this.jdbcDriverType), statement, columnLabelAndIndexMap, addCallback, replayCallback);
    }

    public int executeUpdate(ShardingSphereDatabase database, ShardingSphereMetaData metaData, QueryContext queryContext, StatementExecuteUpdateCallback executeUpdateCallback, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        SQLAuditEngine.audit((QueryContext)queryContext, (ShardingSphereDatabase)database);
        return this.updateExecutor.executeUpdate(database, queryContext, this.createDriverExecutionPrepareEngine(database, metaData, this.jdbcDriverType), executeUpdateCallback, addCallback, replayCallback);
    }

    public boolean execute(ShardingSphereDatabase database, ShardingSphereMetaData metaData, QueryContext queryContext, StatementExecuteCallback executeCallback, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        SQLAuditEngine.audit((QueryContext)queryContext, (ShardingSphereDatabase)database);
        return this.executeExecutor.execute(database, queryContext, this.createDriverExecutionPrepareEngine(database, metaData, this.jdbcDriverType), executeCallback, addCallback, replayCallback);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine(ShardingSphereDatabase database, ShardingSphereMetaData metaData, JDBCDriverType jdbcDriverType) {
        int maxConnectionsSizePerQuery = (Integer)this.connection.getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine(jdbcDriverType, maxConnectionsSizePerQuery, (DatabaseConnectionManager)this.connection.getDatabaseConnectionManager(), (ExecutorStatementManager)this.statementManager, (StorageResourceOption)this.statementOption, database.getRuleMetaData().getRules(), metaData);
    }

    public Optional<ResultSet> getResultSet(ShardingSphereDatabase database, QueryContext queryContext, Statement statement, List<? extends Statement> statements) throws SQLException {
        return this.executeExecutor.getResultSet(database, queryContext, statement, statements);
    }

    @Override
    public void close() throws SQLException {
        this.sqlFederationEngine.close();
    }
}

