/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.pushdown.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.transaction.DialectTransactionOption;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.driver.executor.callback.add.StatementAddCallback;
import org.apache.shardingsphere.driver.executor.callback.execute.ExecuteUpdateCallbackFactory;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteUpdateCallback;
import org.apache.shardingsphere.driver.executor.callback.replay.StatementReplayCallback;
import org.apache.shardingsphere.driver.executor.engine.transaction.DriverTransactionalExecutor;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.mode.metadata.refresher.pushdown.PushDownMetaDataRefreshEngine;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;

public final class DriverJDBCPushDownExecuteUpdateExecutor {
    private final ShardingSphereConnection connection;
    private final String processId;
    private final ConfigurationProperties props;
    private final JDBCExecutor jdbcExecutor;

    public DriverJDBCPushDownExecuteUpdateExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, JDBCExecutor jdbcExecutor) {
        this.connection = connection;
        this.processId = connection.getProcessId();
        this.props = metaData.getProps();
        this.jdbcExecutor = jdbcExecutor;
    }

    public int executeUpdate(ShardingSphereDatabase database, ExecutionContext executionContext, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, StatementExecuteUpdateCallback updateCallback, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        return (Integer)new DriverTransactionalExecutor(this.connection).execute(database, executionContext, () -> this.doExecuteUpdate(database, executionContext, prepareEngine, updateCallback, addCallback, replayCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doExecuteUpdate(ShardingSphereDatabase database, ExecutionContext executionContext, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, StatementExecuteUpdateCallback updateCallback, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        ExecutionGroupContext executionGroupContext = prepareEngine.prepare(database.getName(), executionContext, executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.processId, database.getName(), this.connection.getDatabaseConnectionManager().getConnectionContext().getGrantee()));
        for (ExecutionGroup each : executionGroupContext.getInputGroups()) {
            addCallback.add(this.getStatements((ExecutionGroup<JDBCExecutionUnit>)each), JDBCDriverType.PREPARED_STATEMENT == prepareEngine.getType() ? this.getParameterSets((ExecutionGroup<JDBCExecutionUnit>)each) : Collections.emptyList());
        }
        replayCallback.replay();
        ProcessEngine processEngine = new ProcessEngine();
        try {
            processEngine.executeSQL(executionGroupContext, executionContext.getQueryContext());
            JDBCExecutorCallback<Integer> callback = new ExecuteUpdateCallbackFactory(prepareEngine.getType()).newInstance(database, executionContext.getSqlStatementContext().getSqlStatement(), updateCallback);
            List updateCounts = this.jdbcExecutor.execute(executionGroupContext, callback);
            PushDownMetaDataRefreshEngine pushDownMetaDataRefreshEngine = new PushDownMetaDataRefreshEngine(executionContext.getSqlStatementContext());
            if (pushDownMetaDataRefreshEngine.isNeedRefresh()) {
                if (this.isNeedImplicitCommit(executionContext.getSqlStatementContext().getSqlStatement())) {
                    this.connection.commit();
                }
                pushDownMetaDataRefreshEngine.refresh(this.connection.getContextManager().getPersistServiceFacade().getModeFacade().getMetaDataManagerService(), database, this.props, executionContext.getRouteContext().getRouteUnits());
            }
            int n = this.isNeedAccumulate(database.getRuleMetaData().getRules(), executionContext.getSqlStatementContext()) ? this.accumulate(updateCounts) : ((Integer)updateCounts.get(0)).intValue();
            return n;
        }
        finally {
            processEngine.completeSQLExecution(executionGroupContext.getReportContext().getProcessId());
        }
    }

    private Collection<Statement> getStatements(ExecutionGroup<JDBCExecutionUnit> executionGroup) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (JDBCExecutionUnit each : executionGroup.getInputs()) {
            result.add(each.getStorageResource());
        }
        return result;
    }

    private Collection<List<Object>> getParameterSets(ExecutionGroup<JDBCExecutionUnit> executionGroup) {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        for (JDBCExecutionUnit each : executionGroup.getInputs()) {
            result.add(each.getExecutionUnit().getSqlUnit().getParameters());
        }
        return result;
    }

    private boolean isNeedImplicitCommit(SQLStatement sqlStatement) {
        DialectTransactionOption transactionOption = new DatabaseTypeRegistry(sqlStatement.getDatabaseType()).getDialectDatabaseMetaData().getTransactionOption();
        return !this.connection.getAutoCommit() && sqlStatement instanceof DDLStatement && transactionOption.isDDLNeedImplicitCommit();
    }

    private boolean isNeedAccumulate(Collection<ShardingSphereRule> rules, SQLStatementContext sqlStatementContext) {
        for (ShardingSphereRule each : rules) {
            Optional ruleAttribute = each.getAttributes().findAttribute(DataNodeRuleAttribute.class);
            if (!ruleAttribute.isPresent() || !((DataNodeRuleAttribute)ruleAttribute.get()).isNeedAccumulate(sqlStatementContext.getTablesContext().getTableNames())) continue;
            return true;
        }
        return false;
    }

    private int accumulate(List<Integer> updateResults) {
        int result = 0;
        for (Integer each : updateResults) {
            result += null == each ? 0 : each;
        }
        return result;
    }
}

