/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.SQLTokenGenerators;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class SQLRewriteContext {
    private final ShardingSphereDatabase database;
    private final SQLStatementContext sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final ParameterBuilder parameterBuilder;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final SQLTokenGenerators sqlTokenGenerators = new SQLTokenGenerators();
    private final ConnectionContext connectionContext;

    public SQLRewriteContext(ShardingSphereDatabase database, QueryContext queryContext) {
        this.database = database;
        this.sqlStatementContext = queryContext.getSqlStatementContext();
        this.sql = queryContext.getSql();
        this.parameters = queryContext.getParameters();
        this.connectionContext = queryContext.getConnectionContext();
        this.parameterBuilder = this.containsGroupedParameter(this.sqlStatementContext) ? this.buildGroupedParameterBuilder(this.sqlStatementContext) : new StandardParameterBuilder(this.parameters);
    }

    private boolean containsGroupedParameter(SQLStatementContext sqlStatementContext) {
        return this.containsInsertValues(sqlStatementContext);
    }

    private GroupedParameterBuilder buildGroupedParameterBuilder(SQLStatementContext sqlStatementContext) {
        ArrayList<List<Object>> groupedParams = new ArrayList<List<Object>>();
        ArrayList<Object> beforeGenericParams = new ArrayList<Object>();
        ArrayList<Object> afterGenericParams = new ArrayList<Object>();
        if (sqlStatementContext instanceof InsertStatementContext) {
            groupedParams.addAll(((InsertStatementContext)sqlStatementContext).getGroupedParameters());
            afterGenericParams.addAll(((InsertStatementContext)sqlStatementContext).getOnDuplicateKeyUpdateParameters());
        }
        return new GroupedParameterBuilder(groupedParams, beforeGenericParams, afterGenericParams);
    }

    private boolean containsInsertValues(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof InsertStatementContext)) {
            return false;
        }
        return null == ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
    }

    public void addSQLTokenGenerators(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        this.sqlTokenGenerators.addAll(sqlTokenGenerators);
    }

    public void generateSQLTokens() {
        this.sqlTokens.addAll(this.sqlTokenGenerators.generateSQLTokens(this.database, this.sqlStatementContext, this.parameters, this.connectionContext));
    }

    @Generated
    public ShardingSphereDatabase getDatabase() {
        return this.database;
    }

    @Generated
    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public ParameterBuilder getParameterBuilder() {
        return this.parameterBuilder;
    }

    @Generated
    public List<SQLToken> getSqlTokens() {
        return this.sqlTokens;
    }

    @Generated
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

