/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.datasource;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.DatabaseLeafValueChangedHandler;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.datasource.StorageUnitNodePath;

public final class StorageUnitChangedHandler
implements DatabaseLeafValueChangedHandler {
    private final ContextManager contextManager;

    @Override
    public NodePath getSubscribedNodePath(String databaseName) {
        return new StorageUnitNodePath(databaseName, "([\\w-]+)");
    }

    @Override
    public void handle(String databaseName, DataChangedEvent event) {
        String storageUnitName = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)StorageUnitNodePath.createStorageUnitSearchCriteria((String)databaseName));
        switch (event.getType()) {
            case ADDED: {
                this.handleRegistered(databaseName, storageUnitName);
                break;
            }
            case UPDATED: {
                this.handleAltered(databaseName, storageUnitName);
                break;
            }
            case DELETED: {
                this.handleUnregistered(databaseName, storageUnitName);
                break;
            }
        }
    }

    private void handleRegistered(String databaseName, String storageUnitName) {
        Optional dataSourcePoolProps = this.contextManager.getPersistServiceFacade().getMetaDataFacade().getDataSourceUnitService().load(databaseName, storageUnitName);
        dataSourcePoolProps.ifPresent(dataSourcePoolProperties -> this.contextManager.getMetaDataContextManager().getStorageUnitManager().register(databaseName, Collections.singletonMap(storageUnitName, dataSourcePoolProperties)));
    }

    private void handleAltered(String databaseName, String storageUnitName) {
        Optional dataSourcePoolProps = this.contextManager.getPersistServiceFacade().getMetaDataFacade().getDataSourceUnitService().load(databaseName, storageUnitName);
        dataSourcePoolProps.ifPresent(dataSourcePoolProperties -> this.contextManager.getMetaDataContextManager().getStorageUnitManager().alter(databaseName, Collections.singletonMap(storageUnitName, dataSourcePoolProperties)));
    }

    private void handleUnregistered(String databaseName, String storageUnitName) {
        Preconditions.checkState((boolean)this.contextManager.getMetaDataContexts().getMetaData().containsDatabase(databaseName), (String)"No database '%s' exists.", (Object)databaseName);
        this.contextManager.getMetaDataContextManager().getStorageUnitManager().unregister(databaseName, storageUnitName);
    }

    @Generated
    public StorageUnitChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

