/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.checker.dml;

import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sharding.exception.syntax.SelectMultipleDataSourcesWithCombineException;
import org.apache.shardingsphere.sharding.route.engine.checker.ShardingRouteContextChecker;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class ShardingSelectRouteContextChecker
implements ShardingRouteContextChecker {
    @Override
    public void check(ShardingRule shardingRule, QueryContext queryContext, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        SelectStatement selectStatement = (SelectStatement)queryContext.getSqlStatementContext().getSqlStatement();
        if (selectStatement.getCombine().isPresent() && !this.isRouteToSingleDataSource(routeContext)) {
            throw new SelectMultipleDataSourcesWithCombineException(((CombineSegment)selectStatement.getCombine().get()).getCombineType().name());
        }
    }

    private boolean isRouteToSingleDataSource(RouteContext routeContext) {
        if (routeContext.getRouteUnits().isEmpty()) {
            return true;
        }
        boolean result = true;
        String sampleDataSourceName = ((RouteUnit)routeContext.getRouteUnits().iterator().next()).getDataSourceMapper().getLogicName();
        for (RouteUnit each : routeContext.getRouteUnits()) {
            if (each.getDataSourceMapper().getLogicName().equals(sampleDataSourceName)) continue;
            result = false;
            break;
        }
        return result;
    }
}

