/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.engine;

import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.database.exception.core.exception.syntax.table.NoSuchTableException;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dal.ExplainStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.connection.SQLExecutionInterruptedException;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ExplainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sqlfederation.compiler.SQLFederationCompilerEngine;
import org.apache.shardingsphere.sqlfederation.compiler.SQLFederationExecutionPlan;
import org.apache.shardingsphere.sqlfederation.compiler.compiler.SQLStatementCompiler;
import org.apache.shardingsphere.sqlfederation.compiler.context.CompilerContext;
import org.apache.shardingsphere.sqlfederation.compiler.exception.SQLFederationUnsupportedSQLException;
import org.apache.shardingsphere.sqlfederation.compiler.planner.cache.ExecutionPlanCacheKey;
import org.apache.shardingsphere.sqlfederation.compiler.rel.converter.SQLFederationRelConverter;
import org.apache.shardingsphere.sqlfederation.context.SQLFederationContext;
import org.apache.shardingsphere.sqlfederation.engine.processor.SQLFederationProcessor;
import org.apache.shardingsphere.sqlfederation.engine.processor.SQLFederationProcessorFactory;
import org.apache.shardingsphere.sqlfederation.rule.SQLFederationRule;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationDecider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLFederationEngine
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SQLFederationEngine.class);
    private static final Collection<Class<?>> NEED_THROW_EXCEPTION_TYPES = Arrays.asList(SQLExecutionInterruptedException.class, SQLIntegrityConstraintViolationException.class);
    private static final int MAX_ERROR_MESSAGE_LENGTH = 5000;
    private final ProcessEngine processEngine = new ProcessEngine();
    private volatile Map<ShardingSphereRule, SQLFederationDecider> deciders;
    private final ShardingSphereMetaData metaData;
    private final String currentDatabaseName;
    private final String currentSchemaName;
    private final SQLFederationRule sqlFederationRule;
    private final SQLFederationProcessor processor;
    private QueryContext queryContext;
    private SchemaPlus schemaPlus;
    private ResultSet resultSet;

    public SQLFederationEngine(String currentDatabaseName, String currentSchemaName, ShardingSphereMetaData metaData, ShardingSphereStatistics statistics, JDBCExecutor jdbcExecutor) {
        this.metaData = metaData;
        this.currentDatabaseName = currentDatabaseName;
        this.currentSchemaName = currentSchemaName;
        this.sqlFederationRule = (SQLFederationRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLFederationRule.class);
        this.processor = SQLFederationProcessorFactory.getInstance().newInstance(statistics, jdbcExecutor);
    }

    public boolean isSQLFederationEnabled() {
        return this.sqlFederationRule.getConfiguration().isSqlFederationEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ShardingSphereRule, SQLFederationDecider> getDeciders() {
        if (null == this.deciders) {
            SQLFederationEngine sQLFederationEngine = this;
            synchronized (sQLFederationEngine) {
                if (null == this.deciders) {
                    this.deciders = OrderedSPILoader.getServices(SQLFederationDecider.class, (Collection)this.metaData.getDatabase(this.currentDatabaseName).getRuleMetaData().getRules());
                }
            }
        }
        return this.deciders;
    }

    public boolean decide(QueryContext queryContext, RuleMetaData globalRuleMetaData) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        if (!this.isSQLFederationEnabled() || !this.isSupportedSQLStatementContext(sqlStatementContext)) {
            return false;
        }
        boolean allQueryUseSQLFederation = this.sqlFederationRule.getConfiguration().isAllQueryUseSQLFederation();
        if (allQueryUseSQLFederation) {
            return true;
        }
        Collection databaseNames = sqlStatementContext.getTablesContext().getDatabaseNames();
        if (databaseNames.size() > 1) {
            return true;
        }
        ShardingSphereDatabase usedDatabase = queryContext.getUsedDatabase();
        HashSet includedDataNodes = new HashSet();
        for (Map.Entry<ShardingSphereRule, SQLFederationDecider> entry : this.getDeciders().entrySet()) {
            boolean isUseSQLFederation = entry.getValue().decide(sqlStatementContext, queryContext.getParameters(), globalRuleMetaData, usedDatabase, entry.getKey(), includedDataNodes);
            if (!isUseSQLFederation) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportedSQLStatementContext(SQLStatementContext sqlStatementContext) {
        return this.isSupportedSQLStatement(sqlStatementContext instanceof ExplainStatementContext ? ((ExplainStatementContext)sqlStatementContext).getSqlStatement().getExplainableSQLStatement() : sqlStatementContext.getSqlStatement());
    }

    private boolean isSupportedSQLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof SelectStatement;
    }

    public ResultSet executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationContext federationContext) {
        return this.execute0(prepareEngine, callback, federationContext);
    }

    private ResultSet execute0(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> queryCallback, SQLFederationContext federationContext) {
        this.queryContext = federationContext.getQueryContext();
        this.logSQL(this.queryContext, federationContext.getMetaData().getProps());
        try {
            this.processEngine.executeSQL(new ExecutionGroupContext(Collections.emptyList(), new ExecutionGroupReportContext(federationContext.getProcessId(), this.currentDatabaseName, this.queryContext.getConnectionContext().getGrantee())), this.queryContext);
            SQLStatementContext sqlStatementContext = this.queryContext.getSqlStatementContext() instanceof ExplainStatementContext ? ((ExplainStatementContext)this.queryContext.getSqlStatementContext()).getExplainableSQLStatementContext() : this.queryContext.getSqlStatementContext();
            CompilerContext compilerContext = this.sqlFederationRule.getCompilerContext();
            SQLFederationRelConverter converter = new SQLFederationRelConverter(compilerContext, this.getSchemaPath(sqlStatementContext), sqlStatementContext.getSqlStatement().getDatabaseType(), this.processor.getConvention());
            this.schemaPlus = converter.getSchemaPlus();
            this.processor.prepare(prepareEngine, queryCallback, this.currentDatabaseName, this.currentSchemaName, federationContext, compilerContext, this.schemaPlus);
            SQLFederationExecutionPlan executionPlan = this.compileQuery(converter, this.currentDatabaseName, this.currentSchemaName, federationContext, sqlStatementContext, this.queryContext.getSql(), this.processor.getConvention());
            this.logExecutionPlan(executionPlan, federationContext.getMetaData().getProps());
            this.resultSet = this.processor.executePlan(prepareEngine, queryCallback, executionPlan, converter, federationContext, this.schemaPlus);
            return this.resultSet;
        }
        catch (Exception ex) {
            String errorMessage = this.splitErrorMessage(ex);
            log.error("SQL Federation execute failed, sql {}, parameters {}, reason {}", new Object[]{this.queryContext.getSql(), this.queryContext.getParameters(), errorMessage});
            this.closeResources(federationContext);
            if (NEED_THROW_EXCEPTION_TYPES.stream().anyMatch(each -> each.isAssignableFrom(ex.getClass()))) {
                throw ex;
            }
            throw new SQLFederationUnsupportedSQLException(this.queryContext.getSql(), errorMessage);
        }
    }

    private String splitErrorMessage(Exception ex) {
        return null == ex.getMessage() ? "" : ex.getMessage().substring(0, Math.min(ex.getMessage().length(), 5000));
    }

    private void closeResources(SQLFederationContext federationContext) {
        try {
            this.processEngine.completeSQLExecution(federationContext.getProcessId());
            this.close();
        }
        catch (Exception ex) {
            log.warn("Failed to close SQL federation engine resources: {}", (Object)ex.getMessage());
        }
    }

    private void logSQL(QueryContext queryContext, ConfigurationProperties props) {
        if (!((Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_SHOW)).booleanValue()) {
            return;
        }
        if (queryContext.getParameters().isEmpty()) {
            log.info("SQL Federation Logic SQL: {} ::: {} ::: {}", new Object[]{queryContext.getSql(), this.currentDatabaseName, this.currentSchemaName});
        } else {
            log.info("SQL Federation Logic SQL: {} ::: {} ::: {} ::: {}", new Object[]{queryContext.getSql(), queryContext.getParameters(), this.currentDatabaseName, this.currentSchemaName});
        }
    }

    private void logExecutionPlan(SQLFederationExecutionPlan executionPlan, ConfigurationProperties props) {
        if (((Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_SHOW)).booleanValue()) {
            log.info("SQL Federation Execution Plan: {}", (Object)RelOptUtil.toString((RelNode)executionPlan.getPhysicalPlan(), (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES).replaceAll(", id = \\d+", ""));
        }
    }

    private List<String> getSchemaPath(SQLStatementContext sqlStatementContext) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDialectDatabaseMetaData();
        if (dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent()) {
            return sqlStatementContext.getTablesContext().getSimpleTables().stream().anyMatch(each -> each.getOwner().isPresent()) ? Collections.singletonList(this.currentDatabaseName) : Arrays.asList(this.currentDatabaseName, this.currentSchemaName);
        }
        return Collections.singletonList(this.currentDatabaseName);
    }

    private SQLFederationExecutionPlan compileQuery(SQLFederationRelConverter converter, String databaseName, String schemaName, SQLFederationContext federationContext, SQLStatementContext sqlStatementContext, String sql, Convention convention) {
        SQLStatementCompiler sqlStatementCompiler = new SQLStatementCompiler(converter, convention);
        SQLFederationCompilerEngine compilerEngine = new SQLFederationCompilerEngine(databaseName, schemaName, this.sqlFederationRule.getConfiguration().getExecutionPlanCache());
        return compilerEngine.compile(this.buildCacheKey(federationContext, sqlStatementContext, sql, sqlStatementCompiler), false);
    }

    private ExecutionPlanCacheKey buildCacheKey(SQLFederationContext federationContext, SQLStatementContext sqlStatementContext, String sql, SQLStatementCompiler sqlStatementCompiler) {
        ExecutionPlanCacheKey result = new ExecutionPlanCacheKey(sql, sqlStatementContext.getSqlStatement(), sqlStatementCompiler);
        Collection tableSegments = sqlStatementContext.getTablesContext().getSimpleTables();
        for (SimpleTableSegment each : tableSegments) {
            String originalDatabase = each.getTableName().getTableBoundInfo().map(optional -> optional.getOriginalDatabase().getValue()).orElse(this.currentDatabaseName);
            String originalSchema = each.getTableName().getTableBoundInfo().map(optional -> optional.getOriginalSchema().getValue()).orElse(this.currentSchemaName);
            ShardingSphereTable table = federationContext.getMetaData().getDatabase(originalDatabase).getSchema(originalSchema).getTable(each.getTableName().getIdentifier().getValue());
            ShardingSpherePreconditions.checkNotNull((Object)table, () -> new NoSuchTableException(each.getTableName().getIdentifier().getValue()));
            result.getTableMetaDataVersions().put(Joiner.on((String)".").join(Arrays.asList(originalDatabase, originalSchema, table.getName())), 0);
        }
        return result;
    }

    public ResultSet getResultSet() {
        SQLStatement sqlStatement = this.queryContext.getSqlStatementContext().getSqlStatement();
        return sqlStatement instanceof SelectStatement || sqlStatement instanceof ExplainStatement ? this.resultSet : null;
    }

    @Override
    public void close() throws SQLException {
        LinkedList result = new LinkedList();
        this.closeResultSet().ifPresent(result::add);
        this.release();
        if (result.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException();
        result.forEach(ex::setNextException);
        throw ex;
    }

    private Optional<SQLException> closeResultSet() {
        try {
            if (null != this.resultSet && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
        }
        catch (SQLException ex) {
            return Optional.of(ex);
        }
        return Optional.empty();
    }

    private void release() {
        if (null != this.queryContext && null != this.schemaPlus) {
            this.processor.release(this.currentDatabaseName, this.currentSchemaName, this.queryContext, this.schemaPlus);
        }
    }

    @Generated
    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    @Generated
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    @Generated
    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    @Generated
    public SQLFederationRule getSqlFederationRule() {
        return this.sqlFederationRule;
    }

    @Generated
    public SQLFederationProcessor getProcessor() {
        return this.processor;
    }

    @Generated
    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    @Generated
    public SchemaPlus getSchemaPlus() {
        return this.schemaPlus;
    }
}

