/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.GenericSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.mode.exception.LoadTableMetaDataFailedException;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.metadata.service.DatabaseMetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.metadata.service.SchemaMetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.metadata.service.TableMetaDataPersistDisabledService;
import org.apache.shardingsphere.mode.metadata.persist.metadata.service.TableMetaDataPersistEnabledService;
import org.apache.shardingsphere.mode.metadata.persist.metadata.service.ViewMetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.version.VersionPersistService;
import org.apache.shardingsphere.mode.persist.service.TableMetaDataPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class DatabaseMetaDataPersistFacade {
    private final DatabaseMetaDataPersistService database;
    private final SchemaMetaDataPersistService schema;
    private final TableMetaDataPersistService table;
    private final ViewMetaDataPersistService view;

    public DatabaseMetaDataPersistFacade(PersistRepository repository, VersionPersistService versionPersistService, boolean persistSchemasEnabled) {
        this.database = new DatabaseMetaDataPersistService(repository);
        this.table = persistSchemasEnabled ? new TableMetaDataPersistEnabledService(repository, versionPersistService) : new TableMetaDataPersistDisabledService(repository);
        this.view = new ViewMetaDataPersistService(repository, versionPersistService);
        this.schema = new SchemaMetaDataPersistService(repository, this.table, this.view);
    }

    public void persistReloadDatabase(String databaseName, ShardingSphereDatabase reloadDatabase, ShardingSphereDatabase currentDatabase) {
        Collection toBeAlteredSchemasWithTablesDropped = GenericSchemaManager.getToBeAlteredSchemasWithTablesDropped((ShardingSphereDatabase)reloadDatabase, (ShardingSphereDatabase)currentDatabase);
        Collection toBeAlteredSchemasWithTablesAdded = GenericSchemaManager.getToBeAlteredSchemasWithTablesAdded((ShardingSphereDatabase)reloadDatabase, (ShardingSphereDatabase)currentDatabase);
        toBeAlteredSchemasWithTablesAdded.forEach(each -> this.table.persist(databaseName, each.getName().toLowerCase(), each.getAllTables()));
        toBeAlteredSchemasWithTablesDropped.forEach(each -> this.table.drop(databaseName, each.getName().toLowerCase(), each.getAllTables()));
    }

    public void renameSchema(ShardingSphereMetaData metaData, ShardingSphereDatabase database, String schemaName, String renameSchemaName) {
        ShardingSphereSchema schema = metaData.getDatabase(database.getName()).getSchema(schemaName);
        if (schema.isEmpty()) {
            this.schema.add(database.getName(), renameSchemaName);
        } else {
            this.table.persist(database.getName(), renameSchemaName, schema.getAllTables());
            this.view.persist(database.getName(), renameSchemaName, schema.getAllViews());
        }
        this.schema.drop(database.getName(), schemaName);
    }

    public void unregisterStorageUnits(String databaseName, MetaDataContexts reloadMetaDataContexts) {
        ShardingSphereDatabase database = reloadMetaDataContexts.getMetaData().getDatabase(databaseName);
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getResourceMetaData().getStorageUnits(), database.getRuleMetaData().getRules(), reloadMetaDataContexts.getMetaData().getProps(), new DatabaseTypeRegistry(database.getProtocolType()).getDefaultSchemaName(databaseName));
        try {
            Map schemas = GenericSchemaBuilder.build((DatabaseType)database.getProtocolType(), (GenericSchemaBuilderMaterial)material);
            for (Map.Entry entry : schemas.entrySet()) {
                GenericSchemaManager.getToBeDroppedTables((ShardingSphereSchema)((ShardingSphereSchema)entry.getValue()), (ShardingSphereSchema)database.getSchema((String)entry.getKey())).forEach(each -> this.table.drop(databaseName, (String)entry.getKey(), each.getName()));
            }
        }
        catch (SQLException ex) {
            throw new LoadTableMetaDataFailedException(databaseName, ex);
        }
    }

    public Map<String, Collection<ShardingSphereTable>> persistAlteredTables(String databaseName, MetaDataContexts reloadMetaDataContexts, Collection<String> needReloadTables) {
        ShardingSphereDatabase database = reloadMetaDataContexts.getMetaData().getDatabase(databaseName);
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getResourceMetaData().getStorageUnits(), database.getRuleMetaData().getRules(), reloadMetaDataContexts.getMetaData().getProps(), new DatabaseTypeRegistry(database.getProtocolType()).getDefaultSchemaName(databaseName));
        try {
            Map schemas = GenericSchemaBuilder.build(needReloadTables, (DatabaseType)database.getProtocolType(), (GenericSchemaBuilderMaterial)material);
            HashMap<String, Collection<ShardingSphereTable>> result = new HashMap<String, Collection<ShardingSphereTable>>(schemas.size(), 1.0f);
            for (Map.Entry entry : schemas.entrySet()) {
                Collection tables = GenericSchemaManager.getToBeAddedTables((ShardingSphereSchema)((ShardingSphereSchema)entry.getValue()), (ShardingSphereSchema)database.getSchema((String)entry.getKey()));
                this.table.persist(databaseName, (String)entry.getKey(), tables);
                result.put((String)entry.getKey(), tables);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new LoadTableMetaDataFailedException(databaseName, needReloadTables, ex);
        }
    }

    public void persistCreatedDatabaseSchemas(ShardingSphereDatabase database) {
        database.getAllSchemas().forEach(each -> {
            if (each.isEmpty()) {
                this.schema.add(database.getName(), each.getName());
            } else {
                this.table.persist(database.getName(), each.getName(), each.getAllTables());
            }
        });
    }

    @Generated
    public DatabaseMetaDataPersistService getDatabase() {
        return this.database;
    }

    @Generated
    public SchemaMetaDataPersistService getSchema() {
        return this.schema;
    }

    @Generated
    public TableMetaDataPersistService getTable() {
        return this.table;
    }

    @Generated
    public ViewMetaDataPersistService getView() {
        return this.view;
    }
}

