/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.column;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.shadow.exception.data.UnsupportedShadowColumnTypeException;

public final class ColumnShadowValueValidator {
    private static final Set<Class<?>> UNSUPPORTED_TYPES = new HashSet();

    public static void validate(String table, String column, Comparable<?> shadowValue) {
        UNSUPPORTED_TYPES.forEach(each -> ShardingSpherePreconditions.checkState((!each.isAssignableFrom(shadowValue.getClass()) ? 1 : 0) != 0, () -> new UnsupportedShadowColumnTypeException(table, column, (Class<?>)each)));
    }

    @Generated
    private ColumnShadowValueValidator() {
    }

    static {
        UNSUPPORTED_TYPES.add(Date.class);
        UNSUPPORTED_TYPES.add(Enum.class);
    }
}

