/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.err;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdStatusVector
extends FirebirdPacket {
    private final int gdsCode;
    private final String errorMessage;

    public FirebirdStatusVector(SQLException ex) {
        this.gdsCode = ex.getErrorCode() >= 0x14000001 ? ex.getErrorCode() : 335544382;
        String rawMessage = ex.getMessage();
        int idx = rawMessage.indexOf(59);
        String message = idx >= 0 ? rawMessage.substring(idx + 1).trim() : rawMessage;
        int stateIdx = message.indexOf(" [SQLState:");
        if (stateIdx >= 0) {
            message = message.substring(0, stateIdx).trim();
        }
        this.errorMessage = message;
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
        payload.writeInt4(1);
        payload.writeInt4(this.gdsCode);
        payload.writeInt4(2);
        payload.writeString(this.errorMessage);
        payload.writeInt4(0);
    }

    @Generated
    public int getGdsCode() {
        return this.gdsCode;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

