/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.blob;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.exception.FirebirdProtocolException;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdBlobRegistry;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.blob.FirebirdBlobInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.common.FirebirdCommonInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdBlobInfoReturnPacket
extends FirebirdPacket {
    private static final int BLOB_TYPE_SEGMENTED = 0;
    private final List<FirebirdInfoPacketType> infoItems;

    @Override
    protected void write(FirebirdPacketPayload payload) {
        for (FirebirdInfoPacketType type : this.infoItems) {
            if (type.isCommon()) {
                FirebirdCommonInfoPacketType.parseCommonInfo(payload, (FirebirdCommonInfoPacketType)type);
                continue;
            }
            this.parseBlobInfo(payload, (FirebirdBlobInfoPacketType)type);
        }
    }

    private void parseBlobInfo(FirebirdPacketPayload payload, FirebirdBlobInfoPacketType type) {
        switch (type) {
            case NUM_SEGMENTS: {
                this.writeIntValue(payload, type, this.getSegmentCount());
                return;
            }
            case MAX_SEGMENT: {
                this.writeIntValue(payload, type, this.getSegmentLength());
                return;
            }
            case TOTAL_LENGTH: {
                this.writeIntValue(payload, type, this.getSegmentLength());
                return;
            }
            case TYPE: {
                this.writeIntValue(payload, type, 0);
                return;
            }
        }
        throw new FirebirdProtocolException("Unknown blob information request type %d", type.getCode());
    }

    private void writeIntValue(FirebirdPacketPayload payload, FirebirdBlobInfoPacketType type, int value) {
        payload.writeInt1(type.getCode());
        payload.writeInt2LE(4);
        payload.writeInt4LE(value);
    }

    private int getSegmentLength() {
        byte[] segment = FirebirdBlobRegistry.getSegment();
        return segment == null ? 0 : segment.length;
    }

    private int getSegmentCount() {
        return this.getSegmentLength() == 0 ? 0 : 1;
    }

    @Generated
    public FirebirdBlobInfoReturnPacket(List<FirebirdInfoPacketType> infoItems) {
        this.infoItems = infoItems;
    }

    @Generated
    public List<FirebirdInfoPacketType> getInfoItems() {
        return this.infoItems;
    }
}

