/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.common;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.exception.FirebirdProtocolException;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public enum FirebirdCommonInfoPacketType implements FirebirdInfoPacketType
{
    END(1),
    TRUNCATED(2),
    ERROR(3),
    DATA_NOT_READY(4),
    LENGTH(126),
    FLAG_END(127);

    private static final Map<Integer, FirebirdCommonInfoPacketType> FIREBIRD_INFO_COMMON_TYPE_CACHE;
    private final int code;

    public static FirebirdCommonInfoPacketType valueOf(int code) {
        FirebirdCommonInfoPacketType result = FIREBIRD_INFO_COMMON_TYPE_CACHE.get(code);
        Preconditions.checkNotNull((Object)result, (String)"Cannot find code '%d' in common info type", (int)code);
        return result;
    }

    public static void parseCommonInfo(FirebirdPacketPayload data, FirebirdCommonInfoPacketType type) {
        switch (type) {
            case END: {
                data.writeInt1(END.getCode());
                break;
            }
            default: {
                throw new FirebirdProtocolException("Unknown common information request type %d", type.getCode());
            }
        }
    }

    @Override
    public boolean isCommon() {
        return true;
    }

    @Generated
    private FirebirdCommonInfoPacketType(int code) {
        this.code = code;
    }

    @Override
    @Generated
    public int getCode() {
        return this.code;
    }

    static {
        FIREBIRD_INFO_COMMON_TYPE_CACHE = new HashMap<Integer, FirebirdCommonInfoPacketType>();
        for (FirebirdCommonInfoPacketType each : FirebirdCommonInfoPacketType.values()) {
            FIREBIRD_INFO_COMMON_TYPE_CACHE.put(each.code, each);
        }
    }
}

