/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdBlobBinaryProtocolValue
implements FirebirdBinaryProtocolValue {
    private static final AtomicLong ID_SEQ = new AtomicLong(1L);
    private static final Map<Long, byte[]> STORE = new ConcurrentHashMap<Long, byte[]>();

    public static byte[] getBlobContent(long blobId) {
        return STORE.get(blobId);
    }

    public static void removeBlobContent(long blobId) {
        STORE.remove(blobId);
    }

    private static long register(byte[] bytes) {
        long id = ID_SEQ.getAndIncrement();
        STORE.put(id, null == bytes ? new byte[]{} : Arrays.copyOf(bytes, bytes.length));
        return id;
    }

    private static byte[] readAllBytes(InputStream input) throws IOException {
        try (InputStream in = input;){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int n;
                byte[] buf = new byte[8192];
                while ((n = in.read(buf)) >= 0) {
                    if (n <= 0) continue;
                    out.write(buf, 0, n);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public Object read(FirebirdPacketPayload payload) {
        byte[] bytes = new byte[payload.readInt4()];
        payload.getByteBuf().readBytes(bytes);
        payload.skipPadding(bytes.length);
        return new String(bytes, payload.getCharset());
    }

    @Override
    public void write(FirebirdPacketPayload payload, Object value) {
        long blobId;
        if (null == value) {
            blobId = 0L;
        } else if (value instanceof Long) {
            blobId = (Long)value;
        } else if (value instanceof byte[]) {
            blobId = FirebirdBlobBinaryProtocolValue.register((byte[])value);
        } else if (value instanceof Blob) {
            try {
                blobId = FirebirdBlobBinaryProtocolValue.register(FirebirdBlobBinaryProtocolValue.readAllBytes(((Blob)value).getBinaryStream()));
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Failed to read java.sql.Blob stream", ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to read java.sql.Blob content", ex);
            }
        } else if (value instanceof Clob) {
            try {
                Clob clob = (Clob)value;
                int len = (int)Math.min(Integer.MAX_VALUE, clob.length());
                String str = clob.getSubString(1L, len);
                blobId = FirebirdBlobBinaryProtocolValue.register(str.getBytes(payload.getCharset()));
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Failed to read java.sql.Clob", ex);
            }
        } else {
            blobId = FirebirdBlobBinaryProtocolValue.register(value.toString().getBytes(payload.getCharset()));
        }
        payload.writeInt8(blobId);
    }

    @Override
    public int getLength(FirebirdPacketPayload payload) {
        return 8;
    }
}

