/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdInt16BinaryProtocolValue
implements FirebirdBinaryProtocolValue {
    @Override
    public Object read(FirebirdPacketPayload payload) {
        return payload.getByteBuf().readSlice(16);
    }

    @Override
    public void write(FirebirdPacketPayload payload, Object value) {
        if (value instanceof BigDecimal) {
            byte[] int16 = ((BigDecimal)value).toBigInteger().toByteArray();
            payload.getByteBuf().writeZero(16 - int16.length);
            payload.getByteBuf().writeBytes(int16);
        } else if (value instanceof Integer) {
            payload.getByteBuf().writeZero(12);
            payload.writeInt4((Integer)value);
        } else if (value instanceof BigInteger) {
            byte[] int16 = ((BigInteger)value).toByteArray();
            payload.getByteBuf().writeZero(16 - int16.length);
            payload.getByteBuf().writeBytes(int16);
        } else {
            payload.getByteBuf().writeZero(8);
            payload.writeInt8((Long)value);
        }
    }

    @Override
    public int getLength(FirebirdPacketPayload payload) {
        return 16;
    }
}

