/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.util;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import lombok.Generated;

public final class FirebirdDateTimeUtils {
    static final int NANOSECONDS_PER_FRACTION = 100000;
    static final int FRACTIONS_PER_MILLISECOND = 10;
    static final int FRACTIONS_PER_SECOND = 10000;
    static final int FRACTIONS_PER_MINUTE = 600000;
    static final int FRACTIONS_PER_HOUR = 36000000;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int fractions;

    public FirebirdDateTimeUtils(LocalDateTime localDateTime) {
        this.year = localDateTime.getYear();
        this.month = localDateTime.getMonthValue();
        this.day = localDateTime.getDayOfMonth();
        this.hour = localDateTime.getHour();
        this.minute = localDateTime.getMinute();
        this.second = localDateTime.getSecond();
        this.fractions = localDateTime.getNano() / 100000 % 10000;
    }

    public FirebirdDateTimeUtils() {
        this.year = 0;
        this.month = 1;
        this.day = 1;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        this.fractions = 0;
    }

    public int getEncodedDate() {
        int cpMonth = this.month;
        int cpYear = this.year;
        if (cpMonth > 2) {
            cpMonth -= 3;
        } else {
            cpMonth += 9;
            --cpYear;
        }
        int c = cpYear / 100;
        int ya = cpYear - 100 * c;
        return this.convertDate(c, ya, cpMonth);
    }

    public static int getEncodedDate(LocalDateTime localDateTime) {
        return new FirebirdDateTimeUtils(localDateTime).getEncodedDate();
    }

    private int convertDate(int c, int ya, int cpMonth) {
        return 146097 * c / 4 + 1461 * ya / 4 + (153 * cpMonth + 2) / 5 + this.day + 1721119 - 2400001;
    }

    public FirebirdDateTimeUtils setDate(int encodedDate) {
        int sqlDate = encodedDate - 1721119 + 2400001;
        int century = (4 * sqlDate - 1) / 146097;
        sqlDate = 4 * sqlDate - 1 - 146097 * century;
        this.day = sqlDate / 4;
        sqlDate = (4 * this.day + 3) / 1461;
        this.day = 4 * this.day + 3 - 1461 * sqlDate;
        this.day = (this.day + 5) / 5;
        this.month = (5 * this.day - 3) / 153;
        this.day = 5 * this.day - 3 - 153 * this.month;
        this.day = (this.day + 5) / 5;
        this.year = 100 * century + sqlDate;
        if (this.month < 10) {
            this.month += 3;
        } else {
            this.month -= 9;
            ++this.year;
        }
        return this;
    }

    public int getEncodedTime() {
        return this.hour * 36000000 + this.minute * 600000 + this.second * 10000 + this.fractions;
    }

    public FirebirdDateTimeUtils setTime(int encodedTime) {
        int fractionsInDay = encodedTime;
        this.hour = fractionsInDay / 36000000;
        this.minute = (fractionsInDay -= this.hour * 36000000) / 600000;
        this.second = (fractionsInDay -= this.minute * 600000) / 10000;
        this.fractions = fractionsInDay - this.second * 10000;
        return this;
    }

    public Timestamp asTimestamp() {
        return Timestamp.valueOf(LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.fractions));
    }

    public static Timestamp getDate(int encodedDate) {
        return new FirebirdDateTimeUtils().setDate(encodedDate).asTimestamp();
    }

    public static Timestamp getTime(int encodedTime) {
        return new FirebirdDateTimeUtils().setTime(encodedTime).asTimestamp();
    }

    public static Timestamp getDateTime(int encodedDate, int encodedTime) {
        return new FirebirdDateTimeUtils().setDate(encodedDate).setTime(encodedTime).asTimestamp();
    }

    public static Timestamp getDateTimeWithOffset(int encodedDate, int encodedTime, int offset) {
        return new FirebirdDateTimeUtils().setDate(encodedDate).setTime(encodedTime).asTimestamp();
    }

    @Generated
    public int getYear() {
        return this.year;
    }

    @Generated
    public int getMonth() {
        return this.month;
    }

    @Generated
    public int getDay() {
        return this.day;
    }

    @Generated
    public int getHour() {
        return this.hour;
    }

    @Generated
    public int getMinute() {
        return this.minute;
    }

    @Generated
    public int getSecond() {
        return this.second;
    }

    @Generated
    public int getFractions() {
        return this.fractions;
    }

    @Generated
    public void setYear(int year) {
        this.year = year;
    }

    @Generated
    public void setMonth(int month) {
        this.month = month;
    }

    @Generated
    public void setDay(int day) {
        this.day = day;
    }

    @Generated
    public void setHour(int hour) {
        this.hour = hour;
    }

    @Generated
    public void setMinute(int minute) {
        this.minute = minute;
    }

    @Generated
    public void setSecond(int second) {
        this.second = second;
    }

    @Generated
    public void setFractions(int fractions) {
        this.fractions = fractions;
    }
}

