/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.executor;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.engine.PipelineJobRunnerManager;
import org.apache.shardingsphere.data.pipeline.core.job.executor.DistributedPipelineJobExecutorCallback;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.PipelineJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfigurationUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistService;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.metadata.PipelineProcessConfigurationPersistService;
import org.apache.shardingsphere.data.pipeline.core.registrycenter.repository.PipelineGovernanceFacade;
import org.apache.shardingsphere.data.pipeline.core.task.runner.PipelineTasksRunner;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributedPipelineJobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistributedPipelineJobExecutor.class);
    private final DistributedPipelineJobExecutorCallback callback;
    private final PipelineJobRunnerManager jobRunnerManager = new PipelineJobRunnerManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ShardingContext shardingContext) {
        String jobId = shardingContext.getJobName();
        int shardingItem = shardingContext.getShardingItem();
        log.info("Execute job {}-{}.", (Object)jobId, (Object)shardingItem);
        if (this.jobRunnerManager.isStopping()) {
            log.info("Job is stopping, ignore.");
            return;
        }
        PipelineJobType jobType = PipelineJobIdUtils.parseJobType(jobId);
        PipelineContextKey contextKey = PipelineJobIdUtils.parseContextKey(jobId);
        Object jobConfig = jobType.getOption().getYamlJobConfigurationSwapper().swapToObject(shardingContext.getJobParameter());
        PipelineJobItemManager jobItemManager = new PipelineJobItemManager(jobType.getOption().getYamlJobItemProgressSwapper());
        PipelineJobItemProgress jobItemProgress = jobItemManager.getProgress(shardingContext.getJobName(), shardingItem).orElse(null);
        TransmissionProcessContext jobProcessContext = this.createTransmissionProcessContext(jobId, jobType, contextKey);
        PipelineGovernanceFacade governanceFacade = PipelineAPIFactory.getPipelineGovernanceFacade(contextKey);
        boolean started = false;
        try {
            started = this.execute((PipelineJobItemContext)this.callback.buildJobItemContext(jobConfig, shardingItem, jobItemProgress, jobProcessContext, this.jobRunnerManager.getDataSourceManager()), governanceFacade);
            if (started) {
                PipelineJobProgressPersistService.persistNow(jobId, shardingItem);
            }
        }
        catch (RuntimeException ex) {
            if (!this.jobRunnerManager.isStopping()) {
                log.error("Job {}-{} execution failed.", new Object[]{jobId, shardingItem, ex});
                governanceFacade.getJobItemFacade().getErrorMessage().update(jobId, shardingItem, ex);
                throw ex;
            }
        }
        finally {
            if (started) {
                this.jobRunnerManager.getTasksRunner(shardingItem).ifPresent(PipelineTasksRunner::stop);
            }
        }
    }

    private boolean execute(PipelineJobItemContext jobItemContext, PipelineGovernanceFacade governanceFacade) {
        PipelineTasksRunner tasksRunner;
        int shardingItem = jobItemContext.getShardingItem();
        if (!this.jobRunnerManager.addTasksRunner(shardingItem, tasksRunner = this.callback.buildTasksRunner(jobItemContext))) {
            return false;
        }
        String jobId = jobItemContext.getJobId();
        governanceFacade.getJobItemFacade().getErrorMessage().clean(jobId, shardingItem);
        this.prepare(jobItemContext);
        log.info("Start tasks runner, jobId={}, shardingItem={}.", (Object)jobId, (Object)shardingItem);
        tasksRunner.start();
        return true;
    }

    private TransmissionProcessContext createTransmissionProcessContext(String jobId, PipelineJobType<?> jobType, PipelineContextKey contextKey) {
        if (!jobType.getOption().isTransmissionJob()) {
            return null;
        }
        PipelineProcessConfiguration processConfig = PipelineProcessConfigurationUtils.fillInDefaultValue(new PipelineProcessConfigurationPersistService().load(contextKey, jobType.getType()));
        return new TransmissionProcessContext(jobId, processConfig);
    }

    private void prepare(PipelineJobItemContext jobItemContext) {
        try {
            this.callback.prepare(jobItemContext);
        }
        catch (SQLException ex) {
            throw new PipelineInternalException(ex);
        }
    }

    @Generated
    public DistributedPipelineJobExecutor(DistributedPipelineJobExecutorCallback callback) {
        this.callback = callback;
    }

    @Generated
    public PipelineJobRunnerManager getJobRunnerManager() {
        return this.jobRunnerManager;
    }
}

