/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryDataSparsenessCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryDataSparsenessCalculator.class);
    private static final long EXACT_SPLITTING_RECORDS_COUNT_THRESHOLD = 1000000L;
    private static final BigDecimal MULTIPLE_THRESHOLD = new BigDecimal("1.50");

    public static boolean isIntegerUniqueKeyDataSparse(long tableRecordsCount, Range<BigInteger> uniqueKeyValuesRange) {
        BigDecimal multiple;
        boolean result = false;
        BigInteger lowerBound = uniqueKeyValuesRange.getLowerBound();
        BigInteger upperBound = uniqueKeyValuesRange.getUpperBound();
        if (tableRecordsCount >= 1000000L && null != lowerBound && null != upperBound && (multiple = new BigDecimal(upperBound).subtract(new BigDecimal(lowerBound)).add(BigDecimal.ONE).divide(BigDecimal.valueOf(tableRecordsCount), 2, RoundingMode.HALF_UP)).compareTo(MULTIPLE_THRESHOLD) >= 0) {
            log.info("Table is sparse for integer unique key, table records count: {}, unique key values range: {}, multiple: {}", new Object[]{tableRecordsCount, uniqueKeyValuesRange, multiple});
            result = true;
        }
        return result;
    }

    @Generated
    private InventoryDataSparsenessCalculator() {
    }
}

