/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query;

import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.binary.BinaryCell;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLDataRowPacket
extends PostgreSQLIdentifierPacket {
    private static final byte[] HEX_DIGITS = "0123456789abcdef".getBytes(StandardCharsets.US_ASCII);
    private final Collection<Object> data;

    @Override
    protected void write(PostgreSQLPacketPayload payload) {
        payload.writeInt2(this.data.size());
        for (Object each : this.data) {
            if (each instanceof BinaryCell) {
                this.writeBinaryValue(payload, (BinaryCell)each);
                continue;
            }
            this.writeTextValue(payload, each);
        }
    }

    private void writeBinaryValue(PostgreSQLPacketPayload payload, BinaryCell each) {
        Object value = each.getData();
        if (null == value) {
            payload.writeInt4(-1);
            return;
        }
        PostgreSQLBinaryProtocolValue binaryProtocolValue = PostgreSQLBinaryProtocolValueFactory.getBinaryProtocolValue(each.getColumnType());
        payload.writeInt4(binaryProtocolValue.getColumnLength(payload, value));
        binaryProtocolValue.write(payload, value);
    }

    private void writeTextValue(PostgreSQLPacketPayload payload, Object each) {
        if (null == each) {
            payload.writeInt4(-1);
        } else if (each instanceof byte[]) {
            byte[] columnData = this.encodeByteaText((byte[])each);
            payload.writeInt4(columnData.length);
            payload.writeBytes(columnData);
        } else if (each instanceof SQLXML) {
            this.writeSQLXMLData(payload, each);
        } else if (each instanceof Boolean) {
            byte[] columnData = ((Boolean)each != false ? "t" : "f").getBytes(payload.getCharset());
            payload.writeInt4(columnData.length);
            payload.writeBytes(columnData);
        } else {
            byte[] columnData = each.toString().getBytes(payload.getCharset());
            payload.writeInt4(columnData.length);
            payload.writeBytes(columnData);
        }
    }

    private byte[] encodeByteaText(byte[] value) {
        byte[] result = new byte[value.length * 2 + 2];
        result[0] = 92;
        result[1] = 120;
        for (int i = 0; i < value.length; ++i) {
            int unsignedByte = value[i] & 0xFF;
            result[2 + i * 2] = HEX_DIGITS[unsignedByte >>> 4];
            result[3 + i * 2] = HEX_DIGITS[unsignedByte & 0xF];
        }
        return result;
    }

    private void writeSQLXMLData(PostgreSQLPacketPayload payload, Object data) {
        try {
            byte[] dataBytes = ((SQLXML)data).getString().getBytes(payload.getCharset());
            payload.writeInt4(dataBytes.length);
            payload.writeBytes(dataBytes);
        }
        catch (SQLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLMessagePacketType.DATA_ROW;
    }

    @Generated
    public PostgreSQLDataRowPacket(Collection<Object> data) {
        this.data = data;
    }

    @Generated
    public Collection<Object> getData() {
        return this.data;
    }
}

