/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.sharding.exception.connection.CursorNameNotFoundException;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.CursorToken;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.CursorSQLStatementAttribute;

public final class ShardingCursorTokenGenerator
implements OptionalSQLTokenGenerator<SQLStatementContext> {
    private final ShardingRule rule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        Optional cursorSQLStatementAttribute = sqlStatementContext.getSqlStatement().getAttributes().findAttribute(CursorSQLStatementAttribute.class);
        return cursorSQLStatementAttribute.isPresent() && ((CursorSQLStatementAttribute)cursorSQLStatementAttribute.get()).getCursorName().isPresent();
    }

    public SQLToken generateSQLToken(SQLStatementContext sqlStatementContext) {
        CursorSQLStatementAttribute cursorSQLStatementAttribute = (CursorSQLStatementAttribute)sqlStatementContext.getSqlStatement().getAttributes().getAttribute(CursorSQLStatementAttribute.class);
        CursorNameSegment cursorNameSegment = (CursorNameSegment)cursorSQLStatementAttribute.getCursorName().orElseThrow(CursorNameNotFoundException::new);
        return new CursorToken(cursorNameSegment.getStartIndex(), cursorNameSegment.getStopIndex(), cursorNameSegment.getIdentifier(), sqlStatementContext, this.rule);
    }

    @Generated
    public ShardingCursorTokenGenerator(ShardingRule rule) {
        this.rule = rule;
    }
}

