/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.RemoveToken;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;

public final class ShardingRemoveTokenGenerator
implements CollectionSQLTokenGenerator<SelectStatementContext>,
IgnoreForSingleRoute {
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return this.isContainsAggregationDistinctProjection(sqlStatementContext);
    }

    private boolean isContainsAggregationDistinctProjection(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !((SelectStatementContext)sqlStatementContext).getProjectionsContext().getAggregationDistinctProjections().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(SelectStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        sqlStatementContext.getSqlStatement().getGroupBy().ifPresent(optional -> result.add((SQLToken)new RemoveToken(optional.getStartIndex(), optional.getStopIndex())));
        return result;
    }
}

