/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.command;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.packet.command.CommandPacketType;

public enum MySQLCommandPacketType implements CommandPacketType
{
    COM_SLEEP(0),
    COM_QUIT(1),
    COM_INIT_DB(2),
    COM_QUERY(3),
    COM_FIELD_LIST(4),
    COM_CREATE_DB(5),
    COM_DROP_DB(6),
    COM_REFRESH(7),
    COM_SHUTDOWN(8),
    COM_STATISTICS(9),
    COM_PROCESS_INFO(10),
    COM_CONNECT(11),
    COM_PROCESS_KILL(12),
    COM_DEBUG(13),
    COM_PING(14),
    COM_TIME(15),
    COM_DELAYED_INSERT(16),
    COM_CHANGE_USER(17),
    COM_BINLOG_DUMP(18),
    COM_TABLE_DUMP(19),
    COM_CONNECT_OUT(20),
    COM_REGISTER_SLAVE(21),
    COM_STMT_PREPARE(22),
    COM_STMT_EXECUTE(23),
    COM_STMT_SEND_LONG_DATA(24),
    COM_STMT_CLOSE(25),
    COM_STMT_RESET(26),
    COM_SET_OPTION(27),
    COM_STMT_FETCH(28),
    COM_DAEMON(29),
    COM_BINLOG_DUMP_GTID(30),
    COM_RESET_CONNECTION(31);

    private static final Map<Integer, MySQLCommandPacketType> MYSQL_COMMAND_PACKET_TYPE_CACHE;
    private final int value;

    public static MySQLCommandPacketType valueOf(int value) {
        MySQLCommandPacketType result = MYSQL_COMMAND_PACKET_TYPE_CACHE.get(value);
        Preconditions.checkNotNull((Object)((Object)result), (String)"Cannot find '%s' in command packet type", (int)value);
        return result;
    }

    @Generated
    private MySQLCommandPacketType(int value) {
        this.value = value;
    }

    @Generated
    public int getValue() {
        return this.value;
    }

    static {
        MYSQL_COMMAND_PACKET_TYPE_CACHE = new HashMap<Integer, MySQLCommandPacketType>();
        for (MySQLCommandPacketType each : MySQLCommandPacketType.values()) {
            MYSQL_COMMAND_PACKET_TYPE_CACHE.put(each.value, each);
        }
    }
}

