/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.path;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.agent.core.preconditions.AgentPreconditions;

public final class AgentPath {
    public static File getRootPath() {
        String classResourcePath = String.join((CharSequence)"", AgentPath.class.getName().replaceAll("\\.", "/"), ".class");
        URL resource = Objects.requireNonNull(ClassLoader.getSystemClassLoader().getResource(classResourcePath), "Can not locate agent jar file.");
        return AgentPath.getJarFile(resource.toString()).getParentFile();
    }

    private static File getJarFile(String url) {
        try {
            File result = new File(new URL(url.substring(url.indexOf("file:"), url.indexOf(33))).toURI());
            AgentPreconditions.checkState(result.exists(), String.format("Can not locate agent jar file by URL `%s`.", url));
            return result;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalStateException(String.format("Can not locate agent jar file by URL `%s`.", url), ex);
        }
    }

    @Generated
    private AgentPath() {
    }
}

