/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.zookeeper.exception;

import lombok.Generated;
import org.apache.shardingsphere.mode.repository.cluster.exception.ClusterRepositoryPersistException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZookeeperExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperExceptionHandler.class);

    public static void handleException(Exception cause) {
        if (null == cause) {
            log.info("cause is null");
            return;
        }
        if (ZookeeperExceptionHandler.isIgnoredException(cause) || null != cause.getCause() && ZookeeperExceptionHandler.isIgnoredException(cause.getCause())) {
            log.debug("Ignored exception for: {}", (Object)cause.getMessage());
        } else if (cause instanceof InterruptedException) {
            log.info("InterruptedException caught");
            Thread.currentThread().interrupt();
        } else {
            log.error("Zookeeper exception occured.", (Throwable)cause);
            throw new ClusterRepositoryPersistException(cause);
        }
    }

    private static boolean isIgnoredException(Throwable cause) {
        return cause instanceof KeeperException.ConnectionLossException || cause instanceof KeeperException.NoNodeException || cause instanceof KeeperException.NodeExistsException;
    }

    @Generated
    private ZookeeperExceptionHandler() {
    }
}

