/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.factory;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.SystemSchemaManager;
import org.apache.shardingsphere.infra.metadata.statistics.collector.DialectDatabaseStatisticsCollector;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseMetaDataExecutor;
import org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.executor.OpenGaussSelectDatCompatibilityExecutor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.TableSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class OpenGaussSystemTableQueryExecutorFactory {
    private static final DatabaseType DATABASE_TYPE = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"openGauss");
    private static final Map<String, Collection<String>> SCHEMA_TABLES = new CaseInsensitiveMap();

    public static Optional<DatabaseAdminExecutor> newInstance(SelectStatementContext sqlStatementContext, String sql, List<Object> parameters) {
        Map<String, Collection<String>> selectedSchemaTables = OpenGaussSystemTableQueryExecutorFactory.getSelectedSchemaTables(sqlStatementContext);
        if (OpenGaussSystemTableQueryExecutorFactory.isSelectSystemTable(selectedSchemaTables) && OpenGaussSystemTableQueryExecutorFactory.isSelectDatCompatibility(sqlStatementContext)) {
            return Optional.of(new OpenGaussSelectDatCompatibilityExecutor());
        }
        if (OpenGaussSystemTableQueryExecutorFactory.isSelectedStatisticsSystemTable(selectedSchemaTables) || OpenGaussSystemTableQueryExecutorFactory.isSelectedShardingSphereSystemTable(selectedSchemaTables)) {
            return Optional.empty();
        }
        if (OpenGaussSystemTableQueryExecutorFactory.isSelectSystemTable(selectedSchemaTables)) {
            return Optional.of(new DatabaseMetaDataExecutor(sql, parameters));
        }
        return Optional.empty();
    }

    private static Map<String, Collection<String>> getSelectedSchemaTables(SelectStatementContext selectStatementContext) {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (SimpleTableSegment each : selectStatementContext.getTablesContext().getSimpleTables()) {
            TableNameSegment tableNameSegment = each.getTableName();
            String tableName = tableNameSegment.getIdentifier().getValue();
            String schemaName = tableNameSegment.getTableBoundInfo().map(TableSegmentBoundInfo::getOriginalSchema).map(IdentifierValue::getValue).orElseGet(() -> OpenGaussSystemTableQueryExecutorFactory.getOwnerSchemaName(each));
            Optional.ofNullable(schemaName).ifPresent(arg_0 -> OpenGaussSystemTableQueryExecutorFactory.lambda$getSelectedSchemaTables$2((Map)result, tableName, arg_0));
        }
        return result;
    }

    private static String getOwnerSchemaName(SimpleTableSegment tableSegment) {
        return tableSegment.getOwner().map(OwnerSegment::getIdentifier).map(IdentifierValue::getValue).orElse(null);
    }

    private static boolean isSelectSystemTable(Map<String, Collection<String>> selectedSchemaTables) {
        if (selectedSchemaTables.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Collection<String>> each : selectedSchemaTables.entrySet()) {
            if (SystemSchemaManager.isSystemTable((String)"openGauss", (String)each.getKey(), each.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSelectDatCompatibility(SelectStatementContext selectStatementContext) {
        TablesContext tablesContext = selectStatementContext.getTablesContext();
        boolean isSelectFromPgDatabase = 1 == tablesContext.getSimpleTables().size() && "pg_database".equalsIgnoreCase(((SimpleTableSegment)tablesContext.getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue());
        Collection projections = selectStatementContext.getProjectionsContext().getProjections();
        if (isSelectFromPgDatabase && 1 == projections.size() && projections.iterator().next() instanceof ColumnProjection) {
            ColumnProjection columnProjection = (ColumnProjection)projections.iterator().next();
            ColumnSegmentBoundInfo columnBoundInfo = columnProjection.getColumnBoundInfo();
            return null != columnBoundInfo && "pg_database".equalsIgnoreCase(columnBoundInfo.getOriginalTable().getValue()) && "datcompatibility".equalsIgnoreCase(columnProjection.getName().getValue());
        }
        return false;
    }

    private static boolean isSelectedStatisticsSystemTable(Map<String, Collection<String>> selectedSchemaTables) {
        Optional dialectStatisticsCollector = DatabaseTypedSPILoader.findService(DialectDatabaseStatisticsCollector.class, (DatabaseType)DATABASE_TYPE);
        return dialectStatisticsCollector.map(dialectDatabaseStatisticsCollector -> dialectDatabaseStatisticsCollector.isStatisticsTables(selectedSchemaTables)).orElse(false);
    }

    private static boolean isSelectedShardingSphereSystemTable(Map<String, Collection<String>> selectedSchemaTables) {
        if (selectedSchemaTables.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Collection<String>> each : selectedSchemaTables.entrySet()) {
            if (!SCHEMA_TABLES.containsKey(each.getKey())) {
                return false;
            }
            if (SCHEMA_TABLES.get(each.getKey()).containsAll(each.getValue())) continue;
            return false;
        }
        return true;
    }

    @Generated
    private OpenGaussSystemTableQueryExecutorFactory() {
    }

    private static /* synthetic */ void lambda$getSelectedSchemaTables$2(Map result, String tableName, String optional) {
        result.computeIfAbsent(optional, key -> new CaseInsensitiveSet()).add(tableName);
    }

    static {
        SCHEMA_TABLES.put("shardingsphere", (Collection<String>)new CaseInsensitiveSet(Collections.singletonList("cluster_information")));
    }
}

