/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.h2.jdbcurl;

import org.apache.shardingsphere.database.connector.core.jdbcurl.judger.DatabaseInstanceJudger;
import org.apache.shardingsphere.database.connector.core.jdbcurl.judger.DialectDatabaseInstanceJudger;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;

public final class H2DatabaseInstanceJudger
implements DialectDatabaseInstanceJudger {
    private static final String MODEL_MEM = "mem";
    private static final String MODEL_PWD = "~";
    private static final String MODEL_FILE = "file:";

    public boolean isInSameDatabaseInstance(ConnectionProperties connectionProps1, ConnectionProperties connectionProps2) {
        return this.isSameModel(connectionProps1.getQueryProperties().getProperty("model"), connectionProps2.getQueryProperties().getProperty("model")) && DatabaseInstanceJudger.isInSameDatabaseInstance((ConnectionProperties)connectionProps1, (ConnectionProperties)connectionProps2);
    }

    private boolean isSameModel(String model1, String model2) {
        if (MODEL_MEM.equalsIgnoreCase(model1)) {
            return model1.equalsIgnoreCase(model2) || MODEL_PWD.equalsIgnoreCase(model2) || MODEL_FILE.equalsIgnoreCase(model2);
        }
        if (MODEL_PWD.equalsIgnoreCase(model1)) {
            return model1.equalsIgnoreCase(model2) || MODEL_MEM.equalsIgnoreCase(model2) || MODEL_FILE.equalsIgnoreCase(model2);
        }
        if (MODEL_FILE.equalsIgnoreCase(model1)) {
            return model1.equalsIgnoreCase(model2) || MODEL_MEM.equalsIgnoreCase(model2) || MODEL_PWD.equalsIgnoreCase(model2);
        }
        return model1.equalsIgnoreCase(model2);
    }

    public String getDatabaseType() {
        return "H2";
    }
}

