/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.metadata.schema;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.schema.SQLFederationTable;
import org.apache.shardingsphere.sqlfederation.compiler.sql.type.SQLFederationDataTypeBuilder;
import org.apache.shardingsphere.sqlfederation.compiler.sql.type.SQLFederationDataTypeFactory;

public final class SQLFederationSchema
extends AbstractSchema {
    private final String name;
    private final Map<String, Table> tableMap;

    public SQLFederationSchema(String schemaName, ShardingSphereSchema schema, DatabaseType protocolType) {
        this.name = schemaName;
        this.tableMap = this.createTableMap(schema, protocolType);
    }

    private Map<String, Table> createTableMap(ShardingSphereSchema schema, DatabaseType protocolType) {
        CaseInsensitiveMap result = new CaseInsensitiveMap(schema.getAllTables().size(), 1.0f);
        for (ShardingSphereTable each : schema.getAllTables()) {
            if (schema.containsView(each.getName())) {
                result.put(each.getName(), this.getViewTable(schema, each, protocolType));
                continue;
            }
            result.put(each.getName(), new SQLFederationTable(each, protocolType));
        }
        return result;
    }

    private ViewTable getViewTable(ShardingSphereSchema schema, ShardingSphereTable table, DatabaseType protocolType) {
        RelDataType relDataType = SQLFederationDataTypeBuilder.build(table, protocolType, SQLFederationDataTypeFactory.getInstance());
        ShardingSphereView view = schema.getView(table.getName());
        return new ViewTable(new JavaTypeFactoryImpl().getJavaClass(relDataType), RelDataTypeImpl.proto((RelDataType)relDataType), view.getViewDefinition(), Collections.emptyList(), Collections.emptyList());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }
}

