/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.supporter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.segment.ShadowRuleSegment;

public final class ShadowRuleStatementSupporter {
    public static List<String> getRuleNames(ShadowRuleConfiguration ruleConfig) {
        return null == ruleConfig ? Collections.emptyList() : ShadowRuleStatementSupporter.getDataSources(ruleConfig);
    }

    public static List<String> getRuleNames(Collection<ShadowRuleSegment> segments) {
        return segments.isEmpty() ? Collections.emptyList() : segments.stream().map(ShadowRuleSegment::getRuleName).collect(Collectors.toList());
    }

    private static List<String> getDataSources(ShadowRuleConfiguration ruleConfig) {
        LinkedList<String> result = new LinkedList<String>();
        ruleConfig.getDataSources().forEach(each -> result.add(each.getName()));
        return result;
    }

    public static List<String> getStorageUnitNames(Collection<ShadowRuleSegment> segments) {
        return segments.isEmpty() ? Collections.emptyList() : segments.stream().map(each -> Arrays.asList(each.getSource(), each.getShadow())).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<String> getAlgorithmNames(ShadowRuleConfiguration ruleConfig) {
        return null == ruleConfig ? Collections.emptyList() : new ArrayList(ruleConfig.getShadowAlgorithms().keySet());
    }

    public static List<String> getAlgorithmNames(Collection<ShadowRuleSegment> segments) {
        return segments.isEmpty() ? Collections.emptyList() : segments.stream().flatMap(each -> each.getShadowTableRules().values().stream()).flatMap(Collection::stream).map(ShadowAlgorithmSegment::getAlgorithmName).collect(Collectors.toList());
    }

    public static ShadowTableConfiguration mergeConfiguration(ShadowTableConfiguration existingTableConfig, ShadowTableConfiguration newTableConfig) {
        existingTableConfig.getDataSourceNames().addAll(newTableConfig.getDataSourceNames());
        existingTableConfig.getShadowAlgorithmNames().addAll(newTableConfig.getShadowAlgorithmNames());
        return existingTableConfig;
    }

    @Generated
    private ShadowRuleStatementSupporter() {
    }
}

